/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

abstract class BinaryLogicalOperatorNode
extends BinaryOperatorNode {
    boolean shortCircuitValue;

    BinaryLogicalOperatorNode(ValueNode leftOperand, ValueNode rightOperand, String methodName, ContextManager cm) {
        super(leftOperand, rightOperand, methodName, methodName, "org.apache.derby.iapi.types.BooleanDataValue", "org.apache.derby.iapi.types.BooleanDataValue", cm);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        if (this.leftOperand.isParameterNode() || this.rightOperand.isParameterNode()) {
            throw StandardException.newException((String)"42X19.S.2", (Object[])new Object[0]);
        }
        super.bindExpression(fromList, subqueryList, aggregates);
        return this;
    }

    @Override
    boolean verifyEliminateNots() {
        return this.leftOperand.verifyEliminateNots() && this.rightOperand.verifyEliminateNots();
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.leftOperand.generateExpression(acb, mb);
        mb.dup();
        mb.push(this.shortCircuitValue);
        mb.callMethod((short)185, null, "equals", "boolean", 1);
        mb.conditionalIf();
        mb.callMethod((short)185, null, "getImmutable", "org.apache.derby.iapi.types.BooleanDataValue", 0);
        mb.startElseCode();
        this.rightOperand.generateExpression(acb, mb);
        mb.upCast("org.apache.derby.iapi.types.BooleanDataValue");
        mb.callMethod((short)185, null, this.methodName, "org.apache.derby.iapi.types.BooleanDataValue", 1);
        mb.completeConditional();
    }

    DataTypeDescriptor resolveLogicalBinaryOperator(DataTypeDescriptor leftType, DataTypeDescriptor rightType) throws StandardException {
        if (!leftType.getTypeId().isBooleanTypeId() || !rightType.getTypeId().isBooleanTypeId()) {
            throw StandardException.newException((String)"42Y94", (Object[])new Object[0]);
        }
        return leftType.getNullabilityType(leftType.isNullable() || rightType.isNullable());
    }
}

