/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.db;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.shared.common.error.StandardException;

final class StoreClassFactoryContext
extends ClassFactoryContext {
    private final AccessFactory store;
    private final JarReader jarReader;

    StoreClassFactoryContext(ContextManager cm, ClassFactory cf, AccessFactory store, JarReader jarReader) {
        super(cm, cf);
        this.store = store;
        this.jarReader = jarReader;
    }

    @Override
    public CompatibilitySpace getLockSpace() throws StandardException {
        if (this.store == null) {
            return null;
        }
        return this.store.getTransaction(this.getContextManager()).getLockSpace();
    }

    @Override
    public PersistentSet getPersistentSet() throws StandardException {
        if (this.store == null) {
            return null;
        }
        return this.store.getTransaction(this.getContextManager());
    }

    @Override
    public JarReader getJarReader() {
        return this.jarReader;
    }
}

