/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.sql.Timestamp;
import org.apache.derby.catalog.Statistics;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;

public class StatisticsDescriptor
extends TupleDescriptor {
    private UUID statID;
    private UUID statRefID;
    private UUID statTableID;
    private Timestamp statUpdateTime;
    private String statType;
    private boolean statValid = true;
    private Statistics statStat;
    private int statColumnCount;

    public StatisticsDescriptor(DataDictionary dd, UUID newUUID, UUID objectUUID, UUID tableUUID, String type, Statistics stat, int colCount) {
        super(dd);
        this.statID = newUUID;
        this.statRefID = objectUUID;
        this.statTableID = tableUUID;
        this.statUpdateTime = new Timestamp(System.currentTimeMillis());
        this.statType = "I";
        this.statStat = stat;
        this.statColumnCount = colCount;
    }

    public UUID getUUID() {
        return this.statID;
    }

    public UUID getTableUUID() {
        return this.statTableID;
    }

    public UUID getReferenceID() {
        return this.statRefID;
    }

    public Timestamp getUpdateTimestamp() {
        return DataTypeUtilities.clone(this.statUpdateTime);
    }

    public String getStatType() {
        return this.statType;
    }

    public boolean isValid() {
        return this.statValid;
    }

    public Statistics getStatistic() {
        return this.statStat;
    }

    public int getColumnCount() {
        return this.statColumnCount;
    }

    public String toString() {
        return "statistics: table=" + this.getTableUUID().toString() + ",conglomerate=" + String.valueOf(this.getReferenceID()) + ",colCount=" + this.getColumnCount() + ",stat=" + String.valueOf(this.getStatistic());
    }
}

