/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class FileInfoDescriptor
extends UniqueSQLObjectDescriptor
implements Provider {
    public static final int JAR_FILE_TYPE = 0;
    private final UUID id;
    private final SchemaDescriptor sd;
    private final String sqlName;
    private final long generationId;

    public FileInfoDescriptor(DataDictionary dataDictionary, UUID id, SchemaDescriptor sd, String sqlName, long generationId) {
        super(dataDictionary);
        if (sd.getSchemaName() == null) {
            SanityManager.THROWASSERT((String)("new FileInfoDescriptor() schema name is null for FileInfo " + sqlName));
        }
        this.id = id;
        this.sd = sd;
        this.sqlName = sqlName;
        this.generationId = generationId;
    }

    @Override
    public SchemaDescriptor getSchemaDescriptor() {
        return this.sd;
    }

    @Override
    public String getName() {
        return this.sqlName;
    }

    @Override
    public UUID getUUID() {
        return this.id;
    }

    public long getGenerationId() {
        return this.generationId;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(273);
    }

    @Override
    public String getObjectName() {
        return this.sqlName;
    }

    @Override
    public UUID getObjectID() {
        return this.id;
    }

    @Override
    public String getClassType() {
        return "File";
    }

    @Override
    public String getDescriptorType() {
        return "Jar file";
    }

    @Override
    public String getDescriptorName() {
        return this.sqlName;
    }
}

