/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.shared.common.util.ArrayUtil;

public class DefaultInfoImpl
implements DefaultInfo,
Formatable {
    private DataValueDescriptor defaultValue;
    private String defaultText;
    private int type;
    private String[] referencedColumnNames;
    private String originalCurrentSchema;
    private static final int BITS_MASK_IS_DEFAULTVALUE_AUTOINC = 1;
    private static final int BITS_MASK_IS_GENERATED_COLUMN = 2;

    public DefaultInfoImpl() {
    }

    public DefaultInfoImpl(boolean isDefaultValueAutoinc, String defaultText, DataValueDescriptor defaultValue) {
        this.type = DefaultInfoImpl.calcType(isDefaultValueAutoinc);
        this.defaultText = defaultText;
        this.defaultValue = defaultValue;
    }

    public DefaultInfoImpl(String defaultText, String[] referencedColumnNames, String originalCurrentSchema) {
        if (referencedColumnNames == null) {
            referencedColumnNames = new String[]{};
        }
        this.type = 2;
        this.defaultText = defaultText;
        this.referencedColumnNames = referencedColumnNames;
        this.originalCurrentSchema = originalCurrentSchema;
    }

    @Override
    public String getDefaultText() {
        return this.defaultText;
    }

    @Override
    public String[] getReferencedColumnNames() {
        return (String[])ArrayUtil.copy((Object[])this.referencedColumnNames);
    }

    @Override
    public String getOriginalCurrentSchema() {
        return this.originalCurrentSchema;
    }

    public String toString() {
        if (this.isDefaultValueAutoinc()) {
            return "GENERATED_BY_DEFAULT";
        }
        if (this.isGeneratedColumn()) {
            return "GENERATED ALWAYS AS ( " + this.defaultText + " )";
        }
        return this.defaultText;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.defaultText = (String)in.readObject();
        this.defaultValue = (DataValueDescriptor)in.readObject();
        this.type = in.readInt();
        if (this.isGeneratedColumn()) {
            int count = in.readInt();
            this.referencedColumnNames = new String[count];
            for (int i = 0; i < count; ++i) {
                this.referencedColumnNames[i] = (String)in.readObject();
            }
            this.originalCurrentSchema = (String)in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.defaultText);
        out.writeObject(this.defaultValue);
        out.writeInt(this.type);
        if (this.isGeneratedColumn()) {
            int count = this.referencedColumnNames.length;
            out.writeInt(count);
            for (int i = 0; i < count; ++i) {
                out.writeObject(this.referencedColumnNames[i]);
            }
            out.writeObject(this.originalCurrentSchema);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 326;
    }

    public DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(DataValueDescriptor defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isDefaultValueAutoinc() {
        return (this.type & 1) != 0;
    }

    @Override
    public boolean isGeneratedColumn() {
        return (this.type & 2) != 0;
    }

    private static int calcType(boolean isDefaultValueAutoinc) {
        int value = 0;
        if (isDefaultValueAutoinc) {
            value |= 1;
        }
        return value;
    }
}

