/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;

public final class Utils {
    private static byte[][] tenRadixArr = new byte[][]{{1}, {10}, {100}, {3, -24}, {39, 16}, {1, -122, -96}, {15, 66, 64}, {-104, -106, -128}, {5, -11, -31, 0}, {59, -102, -54, 0}, {2, 84, 11, -28, 0}, {23, 72, 118, -24, 0}, {-24, -44, -91, 16, 0}, {9, 24, 78, 114, -96, 0}, {90, -13, 16, 122, 64, 0}, {3, -115, 126, -92, -58, -128, 0}, {35, -122, -14, 111, -63, 0, 0}, {1, 99, 69, 120, 93, -118, 0, 0}, {13, -32, -74, -77, -89, 100, 0, 0}, {-118, -57, 35, 4, -119, -24, 0, 0}, {5, 107, -57, 94, 45, 99, 16, 0, 0}, {54, 53, -55, -83, -59, -34, -96, 0, 0}, {2, 30, 25, -32, -55, -70, -78, 64, 0, 0}, {21, 45, 2, -57, -31, 74, -10, -128, 0, 0}, {-45, -62, 27, -50, -52, -19, -95, 0, 0, 0}, {8, 69, -107, 22, 20, 1, 72, 74, 0, 0, 0}, {82, -73, -46, -36, -56, 12, -46, -28, 0, 0, 0}, {3, 59, 46, 60, -97, -48, -128, 60, -24, 0, 0, 0}, {32, 79, -50, 94, 62, 37, 2, 97, 16, 0, 0, 0}, {1, 67, 30, 15, -82, 109, 114, 23, -54, -96, 0, 0, 0}, {12, -97, 44, -100, -48, 70, 116, -19, -22, 64, 0, 0, 0}, {126, 55, -66, 32, 34, -64, -111, 75, 38, -128, 0, 0, 0}};

    static String quoteSqlIdentifier(String identifier) {
        StringBuffer retValue = new StringBuffer(identifier.length() + 2);
        int quote = 34;
        retValue.append('\"');
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (ch == '\"') {
                retValue.append('\"');
            }
            retValue.append(ch);
        }
        retValue.append('\"');
        return retValue.toString();
    }

    static String getStringFromBytes(byte[] bytes) {
        if (bytes == null) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer(bytes.length * 6 + 4);
        stringBuffer.append("{ ");
        for (int i = 0; i < bytes.length; ++i) {
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toHexString(bytes[i] & 0xFF));
            if (i == bytes.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    static String getStringFromInts(int[] ints) {
        if (ints == null) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        for (int i = 0; i < ints.length; ++i) {
            stringBuffer.append(String.valueOf(ints[i]));
            if (i == ints.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public static int computeBigDecimalPrecision(BigDecimal decimal) {
        byte[] bBytes = decimal.unscaledValue().abs().toByteArray();
        if (Utils.byteArrayCmp(bBytes, tenRadixArr[tenRadixArr.length - 1]) >= 0) {
            throw new IllegalArgumentException(SqlException.getMessageUtil().getTextMessage("J105", new Object[0]));
        }
        int lo = 0;
        int hi = tenRadixArr.length - 1;
        int mi = (hi + lo) / 2;
        do {
            int compare;
            if ((compare = Utils.byteArrayCmp(bBytes, tenRadixArr[mi])) == 1) {
                lo = mi;
                continue;
            }
            if (compare != -1) break;
            hi = mi;
        } while ((mi = (hi + lo) / 2) != lo);
        return mi + 1;
    }

    private static int byteArrayCmp(byte[] arg1, byte[] arg2) {
        int arg2Offset;
        int length;
        int arg1Offset;
        int diff;
        if (arg1.length > arg2.length) {
            diff = arg1.length - arg2.length;
            for (arg1Offset = 0; arg1Offset < diff; ++arg1Offset) {
                if (arg1[arg1Offset] == 0) continue;
                return 1;
            }
            length = arg2.length;
        } else if (arg1.length < arg2.length) {
            diff = arg2.length - arg1.length;
            for (arg2Offset = 0; arg2Offset < diff; ++arg2Offset) {
                if (arg2[arg2Offset] == 0) continue;
                return -1;
            }
            length = arg1.length;
        } else {
            length = arg1.length;
        }
        for (int i = 0; i < length; ++i) {
            int b1 = arg1[arg1Offset + i] & 0xFF;
            int b2 = arg2[arg2Offset + i] & 0xFF;
            if (b1 > b2) {
                return 1;
            }
            if (b1 >= b2) continue;
            return -1;
        }
        return 0;
    }

    public static int getSqlcodeFromSqlca(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        return sqlca.getSqlCode();
    }

    public static int[] squashLongs(long[] longs) {
        int count = longs == null ? 0 : longs.length;
        int[] ints = new int[count];
        for (int i = 0; i < count; ++i) {
            ints[i] = (int)longs[i];
        }
        return ints;
    }

    public static SQLException accumulateSQLException(SQLException latestException, SQLException accumulatedExceptions) {
        if (accumulatedExceptions == null) {
            return latestException;
        }
        accumulatedExceptions.setNextException(latestException);
        return accumulatedExceptions;
    }

    public static SqlException accumulateSQLException(SqlException latestException, SqlException accumulatedExceptions) {
        if (accumulatedExceptions == null) {
            return latestException;
        }
        accumulatedExceptions.setNextException(latestException);
        return accumulatedExceptions;
    }

    public static boolean isSqlTypeNullable(int sqlType) {
        return (sqlType | 1) == sqlType;
    }

    static int getNonNullableSqlType(int sqlType) {
        return sqlType & 0xFFFFFFFE;
    }
}

