/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.impl.EventDataImpl;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public interface EventData
extends Serializable,
Comparable<EventData> {
    public static EventData create(byte[] data) {
        return new EventDataImpl(data);
    }

    public static EventData create(byte[] data, int offset, int length) {
        return new EventDataImpl(data, offset, length);
    }

    public static EventData create(ByteBuffer buffer) {
        return new EventDataImpl(buffer);
    }

    public Object getObject();

    public byte[] getBytes();

    public Map<String, Object> getProperties();

    public SystemProperties getSystemProperties();

    public void setSystemProperties(SystemProperties var1);

    public static class SystemProperties
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -2827050124966993723L;

        public SystemProperties(HashMap<String, Object> map) {
            super(Collections.unmodifiableMap(map));
        }

        public SystemProperties(long sequenceNumber, Instant enqueuedTimeUtc, String offset, String partitionKey) {
            this.put("x-opt-sequence-number", sequenceNumber);
            this.put("x-opt-enqueued-time", new Date(enqueuedTimeUtc.toEpochMilli()));
            this.put("x-opt-offset", offset);
            this.put("x-opt-partition-key", partitionKey);
        }

        public String getOffset() {
            return (String)this.getSystemProperty("x-opt-offset");
        }

        public String getPartitionKey() {
            return (String)this.getSystemProperty("x-opt-partition-key");
        }

        public Instant getEnqueuedTime() {
            Date enqueuedTimeValue = (Date)this.getSystemProperty("x-opt-enqueued-time");
            return enqueuedTimeValue != null ? enqueuedTimeValue.toInstant() : null;
        }

        public long getSequenceNumber() {
            return (Long)this.getSystemProperty("x-opt-sequence-number");
        }

        public String getPublisher() {
            return (String)this.getSystemProperty("x-opt-publisher");
        }

        private <T> T getSystemProperty(String key) {
            if (this.containsKey(key)) {
                return (T)this.get(key);
            }
            return null;
        }
    }
}

