/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.provider.CipherSuiteInfo;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.DummyX509TrustManager;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.KeyStoreConfig;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ProvKeyManagerFactorySpi;
import org.bouncycastle.jsse.provider.ProvSSLServerSocketFactory;
import org.bouncycastle.jsse.provider.ProvSSLSocketFactory;
import org.bouncycastle.jsse.provider.ProvTrustManagerFactorySpi;
import org.bouncycastle.jsse.provider.SSLEngineUtil;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.X509KeyManagerUtil;
import org.bouncycastle.jsse.provider.X509TrustManagerUtil;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLContextSpi
extends SSLContextSpi {
    private static final Logger LOG = Logger.getLogger(ProvSSLContextSpi.class.getName());
    private static final String PROPERTY_CLIENT_CIPHERSUITES = "jdk.tls.client.cipherSuites";
    private static final String PROPERTY_SERVER_CIPHERSUITES = "jdk.tls.server.cipherSuites";
    private static final String PROPERTY_CLIENT_PROTOCOLS = "jdk.tls.client.protocols";
    private static final String PROPERTY_SERVER_PROTOCOLS = "jdk.tls.server.protocols";
    private static final Map<String, CipherSuiteInfo> SUPPORTED_CIPHERSUITE_MAP = ProvSSLContextSpi.createSupportedCipherSuiteMap();
    private static final Map<String, CipherSuiteInfo> SUPPORTED_CIPHERSUITE_MAP_FIPS = ProvSSLContextSpi.createSupportedCipherSuiteMapFips(SUPPORTED_CIPHERSUITE_MAP, false);
    private static final Map<String, CipherSuiteInfo> SUPPORTED_CIPHERSUITE_MAP_FIPS_GCM12 = ProvSSLContextSpi.createSupportedCipherSuiteMapFips(SUPPORTED_CIPHERSUITE_MAP, true);
    private static final Map<String, ProtocolVersion> SUPPORTED_PROTOCOL_MAP = ProvSSLContextSpi.createSupportedProtocolMap();
    private static final Map<String, ProtocolVersion> SUPPORTED_PROTOCOL_MAP_FIPS = ProvSSLContextSpi.createSupportedProtocolMapFips(SUPPORTED_PROTOCOL_MAP);
    private static final List<String> DEFAULT_CIPHERSUITE_LIST = ProvSSLContextSpi.createDefaultCipherSuiteList(SUPPORTED_CIPHERSUITE_MAP.keySet());
    private static final List<String> DEFAULT_CIPHERSUITE_LIST_FIPS = ProvSSLContextSpi.createDefaultCipherSuiteListFips(DEFAULT_CIPHERSUITE_LIST, false);
    private static final List<String> DEFAULT_CIPHERSUITE_LIST_FIPS_GCM12 = ProvSSLContextSpi.createDefaultCipherSuiteListFips(DEFAULT_CIPHERSUITE_LIST, true);
    private static final List<String> DEFAULT_PROTOCOL_LIST = ProvSSLContextSpi.createDefaultProtocolList(SUPPORTED_PROTOCOL_MAP.keySet());
    private static final List<String> DEFAULT_PROTOCOL_LIST_FIPS = ProvSSLContextSpi.createDefaultProtocolListFips(DEFAULT_PROTOCOL_LIST);
    protected final boolean fipsMode;
    protected final JcaTlsCryptoProvider cryptoProvider;
    protected final List<String> specifiedProtocolsClient;
    private ContextData contextData = null;

    private static void addCipherSuite(Map<String, CipherSuiteInfo> map, String string, int n) {
        CipherSuiteInfo cipherSuiteInfo = CipherSuiteInfo.forCipherSuite(n, string);
        if (null != map.put(string, cipherSuiteInfo)) {
            throw new IllegalStateException("Duplicate names in supported-cipher-suites");
        }
    }

    private static List<String> createDefaultCipherSuiteList(Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TLS_CHACHA20_POLY1305_SHA256");
        arrayList.add("TLS_AES_256_GCM_SHA384");
        arrayList.add("TLS_AES_128_GCM_SHA256");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256");
        arrayList.add("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        arrayList.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256");
        arrayList.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256");
        arrayList.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256");
        arrayList.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        arrayList.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
        arrayList.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
        arrayList.retainAll(set);
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    private static List<String> createDefaultCipherSuiteListFips(List<String> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        FipsUtils.removeNonFipsCipherSuites(arrayList, bl);
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    private static List<String> createDefaultProtocolList(Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TLSv1.3");
        arrayList.add("TLSv1.2");
        arrayList.add("TLSv1.1");
        arrayList.add("TLSv1");
        arrayList.retainAll(set);
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    private static List<String> createDefaultProtocolListFips(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        FipsUtils.removeNonFipsProtocols(arrayList);
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    private static Map<String, CipherSuiteInfo> createSupportedCipherSuiteMap() {
        TreeMap<String, CipherSuiteInfo> treeMap = new TreeMap<String, CipherSuiteInfo>();
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_AES_128_CCM_8_SHA256", 4869);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_AES_128_CCM_SHA256", 4868);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_AES_128_GCM_SHA256", 4865);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_AES_256_GCM_SHA384", 4866);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_CHACHA20_POLY1305_SHA256", 4867);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_AES_128_CBC_SHA", 52);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_AES_128_CBC_SHA256", 108);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_AES_128_GCM_SHA256", 166);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_AES_256_CBC_SHA", 58);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_AES_256_CBC_SHA256", 109);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_AES_256_GCM_SHA384", 167);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_ARIA_128_CBC_SHA256", 49222);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_ARIA_128_GCM_SHA256", 49242);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_ARIA_256_CBC_SHA384", 49223);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_ARIA_256_GCM_SHA384", 49243);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA", 70);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256", 191);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256", 49284);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA", 137);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256", 197);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384", 49285);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", 64);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", 162);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", 56);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", 106);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", 163);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256", 49218);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256", 49238);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384", 49219);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384", 49239);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA", 68);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256", 189);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256", 49280);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA", 135);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256", 195);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384", 49281);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", 103);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_128_CCM", 49310);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_128_CCM_8", 49314);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", 158);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", 107);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_256_CCM", 49311);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_256_CCM_8", 49315);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", 159);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256", 49220);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256", 49234);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384", 49221);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384", 49235);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA", 69);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", 190);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256", 49276);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA", 136);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256", 196);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384", 49277);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52394);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", 49175);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDH_anon_WITH_AES_128_CBC_SHA", 49176);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", 49177);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 49160);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 49161);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_128_CCM", 49324);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8", 49326);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 49162);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_256_CCM", 49325);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8", 49327);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256", 49224);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256", 49244);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384", 49225);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384", 49245);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", 49266);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256", 49286);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", 49267);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384", 49287);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", 52393);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_NULL_SHA", 49158);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 49170);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 49171);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", 49172);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256", 49228);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256", 49248);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384", 49229);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384", 49249);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", 49270);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256", 49290);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384", 49271);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384", 49291);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52392);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_NULL_SHA", 49168);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_3DES_EDE_CBC_SHA", 10);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_128_CBC_SHA", 47);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_128_CBC_SHA256", 60);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_128_CCM", 49308);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_128_CCM_8", 49312);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_128_GCM_SHA256", 156);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_256_CBC_SHA", 53);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_256_CBC_SHA256", 61);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_256_CCM", 49309);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_256_CCM_8", 49313);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_256_GCM_SHA384", 157);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_ARIA_128_CBC_SHA256", 49212);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_ARIA_128_GCM_SHA256", 49232);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_ARIA_256_CBC_SHA384", 49213);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_ARIA_256_GCM_SHA384", 49233);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA", 65);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256", 186);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256", 49274);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA", 132);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256", 192);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384", 49275);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_NULL_SHA", 2);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_NULL_SHA256", 59);
        return Collections.unmodifiableMap(treeMap);
    }

    private static Map<String, CipherSuiteInfo> createSupportedCipherSuiteMapFips(Map<String, CipherSuiteInfo> map, boolean bl) {
        LinkedHashMap<String, CipherSuiteInfo> linkedHashMap = new LinkedHashMap<String, CipherSuiteInfo>(map);
        FipsUtils.removeNonFipsCipherSuites(linkedHashMap.keySet(), bl);
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private static Map<String, ProtocolVersion> createSupportedProtocolMap() {
        LinkedHashMap<String, ProtocolVersion> linkedHashMap = new LinkedHashMap<String, ProtocolVersion>();
        linkedHashMap.put("TLSv1.3", ProtocolVersion.TLSv13);
        linkedHashMap.put("TLSv1.2", ProtocolVersion.TLSv12);
        linkedHashMap.put("TLSv1.1", ProtocolVersion.TLSv11);
        linkedHashMap.put("TLSv1", ProtocolVersion.TLSv10);
        linkedHashMap.put("SSLv3", ProtocolVersion.SSLv3);
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private static Map<String, ProtocolVersion> createSupportedProtocolMapFips(Map<String, ProtocolVersion> map) {
        LinkedHashMap<String, ProtocolVersion> linkedHashMap = new LinkedHashMap<String, ProtocolVersion>(map);
        FipsUtils.removeNonFipsProtocols(linkedHashMap.keySet());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private static String[] getDefaultEnabledCipherSuites(Map<String, CipherSuiteInfo> map, List<String> list, boolean bl, String string) {
        List<String> list2 = ProvSSLContextSpi.getJdkTlsCipherSuites(string, list);
        String[] stringArray = new String[list2.size()];
        int n = 0;
        for (String string2 : list2) {
            CipherSuiteInfo cipherSuiteInfo = map.get(string2);
            if (null == cipherSuiteInfo || bl && list2 == list && TlsDHUtils.isDHCipherSuite(cipherSuiteInfo.getCipherSuite()) || !ProvAlgorithmConstraints.DEFAULT.permits(JsseUtils.KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC, string2, null)) continue;
            stringArray[n++] = string2;
        }
        return JsseUtils.resize(stringArray, n);
    }

    private static String[] getDefaultEnabledCipherSuitesClient(Map<String, CipherSuiteInfo> map, List<String> list) {
        boolean bl = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.dh.disableDefaultSuites", false);
        return ProvSSLContextSpi.getDefaultEnabledCipherSuites(map, list, bl, PROPERTY_CLIENT_CIPHERSUITES);
    }

    private static String[] getDefaultEnabledCipherSuitesServer(Map<String, CipherSuiteInfo> map, List<String> list) {
        boolean bl = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.server.dh.disableDefaultSuites", false);
        return ProvSSLContextSpi.getDefaultEnabledCipherSuites(map, list, bl, PROPERTY_SERVER_CIPHERSUITES);
    }

    private static String[] getDefaultEnabledProtocols(Map<String, ProtocolVersion> map, String string, List<String> list, List<String> list2) {
        List<String> list3 = list2;
        if (null == list3) {
            list3 = ProvSSLContextSpi.getJdkTlsProtocols(string, list);
        }
        String[] stringArray = new String[list3.size()];
        int n = 0;
        for (String string2 : list3) {
            if (!map.containsKey(string2) || !ProvAlgorithmConstraints.DEFAULT_TLS_ONLY.permits(JsseUtils.KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC, string2, null)) continue;
            stringArray[n++] = string2;
        }
        return JsseUtils.resize(stringArray, n);
    }

    private static String[] getDefaultEnabledProtocolsClient(Map<String, ProtocolVersion> map, List<String> list, List<String> list2) {
        return ProvSSLContextSpi.getDefaultEnabledProtocols(map, PROPERTY_CLIENT_PROTOCOLS, list, list2);
    }

    private static String[] getDefaultEnabledProtocolsServer(Map<String, ProtocolVersion> map, List<String> list) {
        return ProvSSLContextSpi.getDefaultEnabledProtocols(map, PROPERTY_SERVER_PROTOCOLS, list, null);
    }

    private static List<String> getJdkTlsCipherSuites(String string, List<String> list) {
        String[] stringArray = PropertyUtils.getStringArraySystemProperty(string);
        if (null == stringArray) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            if (arrayList.contains(string2)) continue;
            if (!SUPPORTED_CIPHERSUITE_MAP.containsKey(string2)) {
                LOG.warning("'" + string + "' contains unsupported cipher suite: " + string2);
                continue;
            }
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            LOG.severe("'" + string + "' contained no supported cipher suites (ignoring)");
            return list;
        }
        return arrayList;
    }

    private static List<String> getJdkTlsProtocols(String string, List<String> list) {
        String[] stringArray = PropertyUtils.getStringArraySystemProperty(string);
        if (null == stringArray) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            if (arrayList.contains(string2)) continue;
            if (!SUPPORTED_PROTOCOL_MAP.containsKey(string2)) {
                LOG.warning("'" + string + "' contains unsupported protocol: " + string2);
                continue;
            }
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            LOG.severe("'" + string + "' contained no supported protocols (ignoring)");
            return list;
        }
        return arrayList;
    }

    static CipherSuiteInfo getCipherSuiteInfo(String string) {
        return SUPPORTED_CIPHERSUITE_MAP.get(string);
    }

    static String getCipherSuiteName(int n) {
        if (0 == n) {
            return "SSL_NULL_WITH_NULL_NULL";
        }
        if (255 == n) {
            return "TLS_EMPTY_RENEGOTIATION_INFO_SCSV";
        }
        if (TlsUtils.isValidUint16(n)) {
            for (CipherSuiteInfo cipherSuiteInfo : SUPPORTED_CIPHERSUITE_MAP.values()) {
                if (cipherSuiteInfo.getCipherSuite() != n) continue;
                return cipherSuiteInfo.getName();
            }
        }
        return null;
    }

    static KeyManager[] getDefaultKeyManagers() throws Exception {
        KeyStoreConfig keyStoreConfig = ProvKeyManagerFactorySpi.getDefaultKeyStore();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStoreConfig.keyStore, keyStoreConfig.password);
        return keyManagerFactory.getKeyManagers();
    }

    static TrustManager[] getDefaultTrustManagers() throws Exception {
        KeyStore keyStore = ProvTrustManagerFactorySpi.getDefaultTrustStore();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    static ProtocolVersion getProtocolVersion(String string) {
        return SUPPORTED_PROTOCOL_MAP.get(string);
    }

    static String getProtocolVersionName(ProtocolVersion protocolVersion) {
        if (null != protocolVersion) {
            for (Map.Entry<String, ProtocolVersion> entry : SUPPORTED_PROTOCOL_MAP.entrySet()) {
                if (!entry.getValue().equals(protocolVersion)) continue;
                return entry.getKey();
            }
        }
        return "NONE";
    }

    ProvSSLContextSpi(boolean bl, JcaTlsCryptoProvider jcaTlsCryptoProvider, List<String> list) {
        this.fipsMode = bl;
        this.cryptoProvider = jcaTlsCryptoProvider;
        this.specifiedProtocolsClient = list;
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine() {
        return SSLEngineUtil.create(this.getContextData());
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine(String string, int n) {
        return SSLEngineUtil.create(this.getContextData(), string, n);
    }

    @Override
    protected synchronized SSLSessionContext engineGetClientSessionContext() {
        return this.getContextData().getClientSessionContext();
    }

    @Override
    protected synchronized SSLSessionContext engineGetServerSessionContext() {
        return this.getContextData().getServerSessionContext();
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return new ProvSSLServerSocketFactory(this.getContextData());
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return new ProvSSLSocketFactory(this.getContextData());
    }

    @Override
    protected SSLParameters engineGetDefaultSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.getContextData().getDefaultSSLParameters(true));
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.getContextData().getSupportedSSLParameters(true));
    }

    @Override
    protected synchronized void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        Map<String, ProtocolVersion> map;
        boolean bl;
        this.contextData = null;
        JcaTlsCrypto jcaTlsCrypto = this.cryptoProvider.create(secureRandom);
        JcaJceHelper jcaJceHelper = jcaTlsCrypto.getHelper();
        BCX509ExtendedKeyManager bCX509ExtendedKeyManager = this.selectX509KeyManager(jcaJceHelper, keyManagerArray);
        BCX509ExtendedTrustManager bCX509ExtendedTrustManager = this.selectX509TrustManager(jcaJceHelper, trustManagerArray);
        jcaTlsCrypto.getSecureRandom().nextInt();
        boolean bl2 = bl = jcaTlsCrypto.getFipsGCMNonceGeneratorFactory() != null;
        Map<String, CipherSuiteInfo> map2 = !this.fipsMode ? SUPPORTED_CIPHERSUITE_MAP : (!bl ? SUPPORTED_CIPHERSUITE_MAP_FIPS : SUPPORTED_CIPHERSUITE_MAP_FIPS_GCM12);
        Map<String, ProtocolVersion> map3 = map = this.fipsMode ? SUPPORTED_PROTOCOL_MAP_FIPS : SUPPORTED_PROTOCOL_MAP;
        List<String> list = !this.fipsMode ? DEFAULT_CIPHERSUITE_LIST : (!bl ? DEFAULT_CIPHERSUITE_LIST_FIPS : DEFAULT_CIPHERSUITE_LIST_FIPS_GCM12);
        String[] stringArray = ProvSSLContextSpi.getDefaultEnabledCipherSuitesClient(map2, list);
        String[] stringArray2 = ProvSSLContextSpi.getDefaultEnabledCipherSuitesServer(map2, list);
        List<String> list2 = this.fipsMode ? DEFAULT_PROTOCOL_LIST_FIPS : DEFAULT_PROTOCOL_LIST;
        String[] stringArray3 = ProvSSLContextSpi.getDefaultEnabledProtocolsClient(map, list2, this.specifiedProtocolsClient);
        String[] stringArray4 = ProvSSLContextSpi.getDefaultEnabledProtocolsServer(map, list2);
        this.contextData = new ContextData(this.fipsMode, jcaTlsCrypto, bCX509ExtendedKeyManager, bCX509ExtendedTrustManager, map2, map, stringArray, stringArray2, stringArray3, stringArray4);
    }

    protected synchronized ContextData getContextData() {
        if (null == this.contextData) {
            throw new IllegalStateException("SSLContext has not been initialized.");
        }
        return this.contextData;
    }

    protected BCX509ExtendedKeyManager selectX509KeyManager(JcaJceHelper jcaJceHelper, KeyManager[] keyManagerArray) throws KeyManagementException {
        if (keyManagerArray != null) {
            for (KeyManager keyManager : keyManagerArray) {
                if (!(keyManager instanceof X509KeyManager)) continue;
                return X509KeyManagerUtil.importX509KeyManager(jcaJceHelper, (X509KeyManager)keyManager);
            }
        }
        return DummyX509KeyManager.INSTANCE;
    }

    protected BCX509ExtendedTrustManager selectX509TrustManager(JcaJceHelper jcaJceHelper, TrustManager[] trustManagerArray) throws KeyManagementException {
        if (trustManagerArray == null) {
            try {
                TrustManager[] trustManagerArray2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerArray2.init((KeyStore)null);
                trustManagerArray = trustManagerArray2.getTrustManagers();
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Failed to load default trust managers", exception);
            }
        }
        if (trustManagerArray != null) {
            for (TrustManager trustManager : trustManagerArray) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                return X509TrustManagerUtil.importX509TrustManager(this.fipsMode, jcaJceHelper, (X509TrustManager)trustManager);
            }
        }
        return DummyX509TrustManager.INSTANCE;
    }
}

