/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.health;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.logstash.health.ImpactArea;

@JsonSerialize(using=JsonSerializer.class)
public final class Impact {
    public final String id;
    public final int severity;
    public final String description;
    public final Set<ImpactArea> impactAreas;

    public Impact(Builder builder) {
        this.id = builder.id;
        this.severity = Objects.requireNonNullElse(builder.severity, 0);
        this.description = builder.description;
        this.impactAreas = Set.copyOf(builder.impactAreas);
    }

    static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private Integer severity;
        private String description;
        private Set<ImpactArea> impactAreas;

        public Builder() {
            this.impactAreas = Set.of();
        }

        private Builder(String id, Integer severity, String description, Set<ImpactArea> impactAreas) {
            this.id = id;
            this.severity = severity;
            this.description = description;
            this.impactAreas = Set.copyOf(impactAreas);
        }

        public synchronized Builder withId(String id) {
            return new Builder(id, this.severity, this.description, this.impactAreas);
        }

        public synchronized Builder withSeverity(int severity) {
            return new Builder(this.id, severity, this.description, this.impactAreas);
        }

        public synchronized Builder withDescription(String description) {
            return new Builder(this.id, this.severity, description, this.impactAreas);
        }

        public synchronized Builder withAdditionalImpactArea(ImpactArea impactArea) {
            HashSet<ImpactArea> mergedImpactAreas = new HashSet<ImpactArea>(this.impactAreas);
            if (!mergedImpactAreas.add(impactArea)) {
                return this;
            }
            return this.withImpactAreas(mergedImpactAreas);
        }

        public synchronized Builder withImpactAreas(Collection<ImpactArea> impactAreas) {
            return new Builder(this.id, this.severity, this.description, Set.copyOf(impactAreas));
        }

        public synchronized Builder transform(UnaryOperator<Builder> configurator) {
            return (Builder)configurator.apply(this);
        }

        public synchronized Impact build() {
            return new Impact(this);
        }
    }

    public static class JsonSerializer
    extends com.fasterxml.jackson.databind.JsonSerializer<Impact> {
        public void serialize(Impact impact, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            if (impact.id != null) {
                jsonGenerator.writeStringField("id", impact.id);
            }
            jsonGenerator.writeNumberField("severity", impact.severity);
            jsonGenerator.writeStringField("description", impact.description);
            jsonGenerator.writeObjectField("impact_areas", impact.impactAreas);
            jsonGenerator.writeEndObject();
        }
    }
}

