/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.graph;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.SourceComponent;
import org.logstash.config.ir.expression.BooleanExpression;
import org.logstash.config.ir.graph.BooleanEdge;
import org.logstash.config.ir.graph.Edge;
import org.logstash.config.ir.graph.Vertex;

public class IfVertex
extends Vertex {
    private final BooleanExpression booleanExpression;

    public BooleanExpression getBooleanExpression() {
        return this.booleanExpression;
    }

    public IfVertex(SourceWithMetadata meta, BooleanExpression booleanExpression) {
        super(meta);
        this.booleanExpression = booleanExpression;
    }

    public String toString() {
        return "[if " + this.booleanExpression.toString(0) + "]";
    }

    @Override
    public boolean sourceComponentEquals(SourceComponent other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof IfVertex) {
            IfVertex otherV = (IfVertex)other;
            return otherV.booleanExpression.sourceComponentEquals(this.booleanExpression);
        }
        return false;
    }

    public boolean hasEdgeType(boolean type) {
        for (Edge e : this.getOutgoingEdges()) {
            BooleanEdge bEdge = (BooleanEdge)e;
            if (bEdge.getEdgeType() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Edge.EdgeFactory> getUnusedOutgoingEdgeFactories() {
        LinkedList<Edge.EdgeFactory> l = new LinkedList<Edge.EdgeFactory>();
        if (!this.hasEdgeType(true)) {
            l.add(BooleanEdge.trueFactory);
        }
        if (!this.hasEdgeType(false)) {
            l.add(BooleanEdge.falseFactory);
        }
        return l;
    }

    @Override
    public boolean acceptsOutgoingEdge(Edge e) {
        return e instanceof BooleanEdge;
    }

    public Stream<BooleanEdge> outgoingBooleanEdgesByType(boolean edgeType) {
        return this.outgoingEdges().map(e -> (BooleanEdge)e).filter(e -> e.getEdgeType() == edgeType);
    }

    public String humanReadableExpression() {
        String sourceText;
        String string = sourceText = this.booleanExpression.getSourceWithMetadata() != null ? this.booleanExpression.getSourceWithMetadata().getText() : null;
        if (sourceText != null) {
            return sourceText;
        }
        return this.getBooleanExpression().toRubyString();
    }

    @Override
    public IfVertex copy() {
        return new IfVertex(this.getSourceWithMetadata(), this.booleanExpression);
    }
}

