/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

abstract class MemoryOp {
    public static final MemoryOp BOOL = new BooleanOp();
    public static final MemoryOp INT8 = new Signed8();
    public static final MemoryOp UINT8 = new Unsigned8();
    public static final MemoryOp INT16 = new Signed16();
    public static final MemoryOp UINT16 = new Unsigned16();
    public static final MemoryOp INT32 = new Signed32();
    public static final MemoryOp UINT32 = new Unsigned32();
    public static final MemoryOp INT64 = new Signed64();
    public static final MemoryOp UINT64 = new Unsigned64();
    public static final MemoryOp FLOAT32 = new Float32();
    public static final MemoryOp FLOAT64 = new Float64();
    public static final MemoryOp FLOAT128 = new Float128();
    public static final MemoryOp INT16SWAP = new Signed16Swapped();
    public static final MemoryOp UINT16SWAP = new Unsigned16Swapped();
    public static final MemoryOp INT32SWAP = new Signed32Swapped();
    public static final MemoryOp UINT32SWAP = new Unsigned32Swapped();
    public static final MemoryOp INT64SWAP = new Signed64Swapped();
    public static final MemoryOp UINT64SWAP = new Unsigned64Swapped();
    public static final MemoryOp POINTER = new PointerOp();

    MemoryOp() {
    }

    public static MemoryOp getMemoryOp(NativeType type2) {
        return MemoryOp.getMemoryOp(type2, ByteOrder.nativeOrder());
    }

    public static MemoryOp getMemoryOp(NativeType type2, ByteOrder order2) {
        switch (type2) {
            case BOOL: {
                return BOOL;
            }
            case CHAR: {
                return INT8;
            }
            case UCHAR: {
                return UINT8;
            }
            case SHORT: {
                return order2.equals(ByteOrder.nativeOrder()) ? INT16 : INT16SWAP;
            }
            case USHORT: {
                return order2.equals(ByteOrder.nativeOrder()) ? UINT16 : UINT16SWAP;
            }
            case INT: {
                return order2.equals(ByteOrder.nativeOrder()) ? INT32 : INT32SWAP;
            }
            case UINT: {
                return order2.equals(ByteOrder.nativeOrder()) ? UINT32 : UINT32SWAP;
            }
            case LONG_LONG: {
                return order2.equals(ByteOrder.nativeOrder()) ? INT64 : INT64SWAP;
            }
            case ULONG_LONG: {
                return order2.equals(ByteOrder.nativeOrder()) ? UINT64 : UINT64SWAP;
            }
            case FLOAT: {
                return FLOAT32;
            }
            case DOUBLE: {
                return FLOAT64;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? MemoryOp.getMemoryOp(NativeType.INT, order2) : MemoryOp.getMemoryOp(NativeType.LONG_LONG, order2);
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? MemoryOp.getMemoryOp(NativeType.UINT, order2) : MemoryOp.getMemoryOp(NativeType.ULONG_LONG, order2);
            }
            case POINTER: {
                return POINTER;
            }
        }
        return null;
    }

    public static MemoryOp getMemoryOp(Type type2) {
        return MemoryOp.getMemoryOp(type2, ByteOrder.nativeOrder());
    }

    public static MemoryOp getMemoryOp(Type type2, ByteOrder order2) {
        if (type2 instanceof Type.Builtin) {
            return MemoryOp.getMemoryOp(type2.getNativeType(), order2);
        }
        if (type2 instanceof StructByValue) {
            StructByValue sbv = (StructByValue)type2;
            return new StructOp(sbv.getStructClass());
        }
        if (type2 instanceof MappedType) {
            return new Mapped(MemoryOp.getMemoryOp(((MappedType)type2).getRealType(), order2), (MappedType)type2);
        }
        return null;
    }

    abstract IRubyObject get(ThreadContext var1, MemoryIO var2, long var3);

    abstract void put(ThreadContext var1, MemoryIO var2, long var3, IRubyObject var5);

    IRubyObject get(ThreadContext context, AbstractMemory ptr, long offset2) {
        return this.get(context, ptr.getMemoryIO(), offset2);
    }

    void put(ThreadContext context, AbstractMemory ptr, long offset2, IRubyObject value2) {
        this.put(context, ptr.getMemoryIO(), offset2, value2);
    }

    static final class Mapped
    extends MemoryOp {
        private final MemoryOp nativeOp;
        private final MappedType mappedType;

        public Mapped(MemoryOp nativeOp, MappedType mappedType) {
            this.nativeOp = nativeOp;
            this.mappedType = mappedType;
        }

        @Override
        IRubyObject get(ThreadContext context, AbstractMemory ptr, long offset2) {
            return this.mappedType.fromNative(context, this.nativeOp.get(context, ptr, offset2));
        }

        @Override
        void put(ThreadContext context, AbstractMemory ptr, long offset2, IRubyObject value2) {
            this.nativeOp.put(context, ptr, offset2, this.mappedType.toNative(context, value2));
        }

        @Override
        IRubyObject get(ThreadContext context, MemoryIO io2, long offset2) {
            return this.mappedType.fromNative(context, this.nativeOp.get(context, io2, offset2));
        }

        @Override
        void put(ThreadContext context, MemoryIO io2, long offset2, IRubyObject value2) {
            this.nativeOp.put(context, io2, offset2, this.mappedType.toNative(context, value2));
        }
    }

    static final class StructOp
    extends MemoryOp {
        private final RubyClass structClass;

        public StructOp(RubyClass structClass) {
            this.structClass = structClass;
        }

        @Override
        IRubyObject get(ThreadContext context, MemoryIO io2, long offset2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        void put(ThreadContext context, MemoryIO io2, long offset2, IRubyObject value2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        IRubyObject get(ThreadContext context, AbstractMemory ptr, long offset2) {
            return this.structClass.newInstance(context, new IRubyObject[]{ptr.slice(context.runtime, offset2)}, Block.NULL_BLOCK);
        }

        @Override
        void put(ThreadContext context, AbstractMemory ptr, long offset2, IRubyObject value2) {
            if (!(value2 instanceof Struct)) {
                throw context.runtime.newTypeError("expected a struct");
            }
            Struct s2 = (Struct)value2;
            byte[] tmp = new byte[Struct.getStructSize(context.runtime, s2)];
            s2.getMemoryIO().get(0L, tmp, 0, tmp.length);
            ptr.getMemoryIO().put(offset2, tmp, 0, tmp.length);
        }
    }

    static final class PointerOp
    extends PrimitiveOp {
        PointerOp() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putMemoryIO(offset2, ((AbstractMemory)value2).getMemoryIO());
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return new Pointer(runtime2, io2.getMemoryIO(offset2));
        }
    }

    static final class Float128
    extends PrimitiveOp {
        Float128() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return runtime2.newFloat(0.0);
        }
    }

    static final class Float64
    extends PrimitiveOp {
        Float64() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putDouble(offset2, Util.doubleValue(value2));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return runtime2.newFloat(io2.getDouble(offset2));
        }
    }

    static final class Float32
    extends PrimitiveOp {
        Float32() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putFloat(offset2, Util.floatValue(value2));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return runtime2.newFloat(io2.getFloat(offset2));
        }
    }

    static final class Unsigned64Swapped
    extends PrimitiveOp {
        Unsigned64Swapped() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putLong(offset2, Long.reverseBytes(Util.uint64Value(value2)));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned64(runtime2, Long.reverseBytes(io2.getLong(offset2)));
        }
    }

    static final class Unsigned64
    extends PrimitiveOp {
        Unsigned64() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putLong(offset2, Util.uint64Value(value2));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned64(runtime2, io2.getLong(offset2));
        }
    }

    static final class Signed64Swapped
    extends PrimitiveOp {
        Signed64Swapped() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putLong(offset2, Long.reverseBytes(Util.int64Value(value2)));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned64(runtime2, Long.reverseBytes(io2.getLong(offset2)));
        }
    }

    static final class Signed64
    extends PrimitiveOp {
        Signed64() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putLong(offset2, Util.int64Value(value2));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned64(runtime2, io2.getLong(offset2));
        }
    }

    static final class Unsigned32Swapped
    extends PrimitiveOp {
        Unsigned32Swapped() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putInt(offset2, Integer.reverseBytes((int)Util.uint32Value(value2)));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned32(runtime2, Integer.reverseBytes(io2.getInt(offset2)));
        }
    }

    static final class Unsigned32
    extends PrimitiveOp {
        Unsigned32() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putInt(offset2, (int)Util.uint32Value(value2));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned32(runtime2, io2.getInt(offset2));
        }
    }

    static final class Signed32Swapped
    extends PrimitiveOp {
        Signed32Swapped() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putInt(offset2, Integer.reverseBytes(Util.int32Value(value2)));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned32(runtime2, Integer.reverseBytes(io2.getInt(offset2)));
        }
    }

    static final class Signed32
    extends PrimitiveOp {
        Signed32() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putInt(offset2, Util.int32Value(value2));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned32(runtime2, io2.getInt(offset2));
        }
    }

    static final class Unsigned16Swapped
    extends PrimitiveOp {
        Unsigned16Swapped() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putShort(offset2, Short.reverseBytes((short)Util.uint16Value(value2)));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned16(runtime2, Short.reverseBytes(io2.getShort(offset2)));
        }
    }

    static final class Unsigned16
    extends PrimitiveOp {
        Unsigned16() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putShort(offset2, (short)Util.uint16Value(value2));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned16(runtime2, io2.getShort(offset2));
        }
    }

    static final class Signed16Swapped
    extends PrimitiveOp {
        Signed16Swapped() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putShort(offset2, Short.reverseBytes(Util.int16Value(value2)));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned16(runtime2, Short.reverseBytes(io2.getShort(offset2)));
        }
    }

    static final class Signed16
    extends PrimitiveOp {
        Signed16() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putShort(offset2, Util.int16Value(value2));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned16(runtime2, io2.getShort(offset2));
        }
    }

    static final class Unsigned8
    extends PrimitiveOp {
        Unsigned8() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putByte(offset2, (byte)Util.uint8Value(value2));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned8(runtime2, io2.getByte(offset2));
        }
    }

    static final class Signed8
    extends PrimitiveOp {
        Signed8() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putByte(offset2, Util.int8Value(value2));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned8(runtime2, io2.getByte(offset2));
        }
    }

    static final class BooleanOp
    extends PrimitiveOp {
        BooleanOp() {
        }

        @Override
        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putByte(offset2, (byte)(value2.isTrue() ? 1 : 0));
        }

        @Override
        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return runtime2.newBoolean(io2.getByte(offset2) != 0);
        }
    }

    static abstract class PrimitiveOp
    extends MemoryOp {
        PrimitiveOp() {
        }

        abstract IRubyObject get(Ruby var1, MemoryIO var2, long var3);

        abstract void put(Ruby var1, MemoryIO var2, long var3, IRubyObject var5);

        @Override
        IRubyObject get(ThreadContext context, MemoryIO io2, long offset2) {
            return this.get(context.runtime, io2, offset2);
        }

        @Override
        void put(ThreadContext context, MemoryIO io2, long offset2, IRubyObject value2) {
            this.put(context.runtime, io2, offset2, value2);
        }
    }
}

