/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.HashNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.StarNode;
import org.jruby.ast.visitor.NodeVisitor;

public class HashPatternNode
extends Node {
    private final Node restArg;
    private final HashNode keywordArgs;
    private Node constant;

    public HashPatternNode(int line, Node restArg, HashNode keywordArgs) {
        super(line, false);
        this.restArg = restArg;
        this.keywordArgs = keywordArgs;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitHashPatternNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return HashPatternNode.createList(this.restArg, (Node)this.keywordArgs, this.constant);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.HASHPATTERNNODE;
    }

    public Node getConstant() {
        return this.constant;
    }

    public void setConstant(Node constant) {
        this.constant = constant;
    }

    public int getArgumentSize() {
        return this.keywordArgs == null ? 0 : this.keywordArgs.getPairs().size();
    }

    public Node getRestArg() {
        return this.restArg;
    }

    public boolean hasRestArg() {
        return this.restArg != null;
    }

    public boolean isNamedRestArg() {
        return !(this.restArg instanceof StarNode);
    }

    public boolean hasKeywordArgs() {
        return this.keywordArgs != null && !this.keywordArgs.isEmpty() || this.hasRestArg();
    }

    public HashNode getKeywordArgs() {
        return this.keywordArgs;
    }

    public Node[] getKeys() {
        return this.keywordArgs.getKeys();
    }

    public boolean hashNamedKeywordRestArg() {
        return this.hasRestArg() && !(this.restArg instanceof StarNode);
    }
}

