/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect;

import java.io.Serializable;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.dissect.Dissector;

final class DissectPair
implements Serializable {
    private static final long serialVersionUID = 8736122873297905474L;
    static final DissectPair[] EMPTY_ARRAY = new DissectPair[0];
    private final RubyString lhs;
    private final String jlhs;
    private final boolean empty;
    private final Dissector dissector;

    static DissectPair[] createArrayFromHash(RubyHash hash) {
        if (hash.isNil()) {
            return EMPTY_ARRAY;
        }
        IRubyObject[] dissectPairs = hash.to_a().toJavaArray();
        DissectPair[] pairs = new DissectPair[dissectPairs.length];
        for (int idx = 0; idx < dissectPairs.length; ++idx) {
            pairs[idx] = DissectPair.create((RubyArray)dissectPairs[idx]);
        }
        return pairs;
    }

    private static DissectPair create(RubyArray pair) {
        return new DissectPair(pair.first().asString(), pair.last().toString());
    }

    private DissectPair(RubyString left, String val) {
        this.lhs = left;
        this.jlhs = this.lhs.toString();
        this.empty = val.isEmpty();
        this.dissector = this.empty ? new Dissector() : Dissector.create(val);
    }

    RubyString key() {
        return this.lhs;
    }

    String javaKey() {
        return this.jlhs;
    }

    Dissector dissector() {
        return this.dissector;
    }

    boolean isEmpty() {
        return this.empty;
    }
}

