/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.OrderRelation;
import com.thaiopensource.datatype.xsd.RegexDatatype;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.relaxng.datatype.ValidationContext;

class DurationDatatype
extends RegexDatatype
implements OrderRelation {
    private static final String PATTERN = "-?P([0-9]+Y)?([0-9]+M)?([0-9]+D)?(T([0-9]+H)?([0-9]+M)?(([0-9]+(\\.[0-9]*)?|\\.[0-9]+)S)?)?";
    private static final int[] REF_YEAR_MONTHS = new int[]{1696, 9, 1697, 2, 1903, 3, 1903, 7};

    DurationDatatype() {
        super(PATTERN);
    }

    @Override
    public boolean lexicallyAllows(String string) {
        if (!super.lexicallyAllows(string)) {
            return false;
        }
        char c = string.charAt(string.length() - 1);
        return c != 'P' && c != 'T';
    }

    @Override
    Object getValue(String string, ValidationContext validationContext) {
        int n = string.indexOf(84);
        if (n < 0) {
            n = string.length();
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        return new Duration(string.charAt(0) == '-', DurationDatatype.getIntegerField(string2, 'Y'), DurationDatatype.getIntegerField(string2, 'M'), DurationDatatype.getIntegerField(string2, 'D'), DurationDatatype.getIntegerField(string3, 'H'), DurationDatatype.getIntegerField(string3, 'M'), DurationDatatype.getDecimalField(string3, 'S'));
    }

    private static BigInteger getIntegerField(String string, char c) {
        int n = string.indexOf(c);
        if (n < 0) {
            return BigInteger.valueOf(0L);
        }
        int n2 = n;
        while (Character.isDigit(string.charAt(n2 - 1))) {
            --n2;
        }
        return new BigInteger(string.substring(n2, n));
    }

    private static BigDecimal getDecimalField(String string, char c) {
        int n = string.indexOf(c);
        if (n < 0) {
            return BigDecimal.valueOf(0L);
        }
        int n2 = n;
        while (!Character.isLetter(string.charAt(n2 - 1))) {
            --n2;
        }
        return new BigDecimal(string.substring(n2, n));
    }

    @Override
    OrderRelation getOrderRelation() {
        return this;
    }

    @Override
    public boolean isLessThan(Object object, Object object2) {
        Duration duration = (Duration)object;
        Duration duration2 = (Duration)object2;
        BigInteger bigInteger = DurationDatatype.computeMonths(duration);
        BigInteger bigInteger2 = DurationDatatype.computeMonths(duration2);
        BigDecimal bigDecimal = DurationDatatype.computeSeconds(duration);
        BigDecimal bigDecimal2 = DurationDatatype.computeSeconds(duration2);
        switch (bigInteger.compareTo(bigInteger2)) {
            case -1: {
                if (bigDecimal.compareTo(bigDecimal2) > 0) break;
                return true;
            }
            case 0: {
                return bigDecimal.compareTo(bigDecimal2) < 0;
            }
            case 1: {
                if (bigDecimal.compareTo(bigDecimal2) < 0) break;
                return false;
            }
        }
        for (int i = 0; i < REF_YEAR_MONTHS.length; i += 2) {
            BigDecimal bigDecimal3;
            BigDecimal bigDecimal4 = DurationDatatype.daysPlusSeconds(DurationDatatype.computeDays(bigInteger, REF_YEAR_MONTHS[i], REF_YEAR_MONTHS[i + 1]), bigDecimal);
            if (bigDecimal4.compareTo(bigDecimal3 = DurationDatatype.daysPlusSeconds(DurationDatatype.computeDays(bigInteger2, REF_YEAR_MONTHS[i], REF_YEAR_MONTHS[i + 1]), bigDecimal2)) < 0) continue;
            return false;
        }
        return true;
    }

    private static BigInteger computeDays(BigInteger bigInteger, int n, int n2) {
        switch (bigInteger.signum()) {
            case 0: {
                return BigInteger.valueOf(0L);
            }
            case -1: {
                return DurationDatatype.computeDays(bigInteger.negate(), n, n2).negate();
            }
        }
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BigInteger.valueOf(4800L));
        --n2;
        int n3 = 0;
        for (int i = bigIntegerArray[1].intValue(); i > 0; --i) {
            n3 += DurationDatatype.daysInMonth(n, n2);
            if (++n2 != 12) continue;
            n2 = 0;
            ++n;
        }
        return bigIntegerArray[0].multiply(BigInteger.valueOf(146097L)).add(BigInteger.valueOf(n3));
    }

    private static int daysInMonth(int n, int n2) {
        switch (n2) {
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return DurationDatatype.isLeapYear(n) ? 29 : 28;
            }
        }
        return 31;
    }

    private static boolean isLeapYear(int n) {
        return n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
    }

    private static BigDecimal daysPlusSeconds(BigInteger bigInteger, BigDecimal bigDecimal) {
        return bigDecimal.add(new BigDecimal(bigInteger.multiply(BigInteger.valueOf(86400L))));
    }

    private static BigInteger computeMonths(Duration duration) {
        return duration.getYears().multiply(BigInteger.valueOf(12L)).add(duration.getMonths());
    }

    private static BigDecimal computeSeconds(Duration duration) {
        return duration.getSeconds().add(new BigDecimal(duration.getDays().multiply(BigInteger.valueOf(24L)).add(duration.getHours()).multiply(BigInteger.valueOf(60L)).add(duration.getMinutes()).multiply(BigInteger.valueOf(60L))));
    }

    public static void main(String[] stringArray) {
        DurationDatatype durationDatatype = new DurationDatatype();
        System.err.println(durationDatatype.isLessThan(durationDatatype.getValue(stringArray[0], null), durationDatatype.getValue(stringArray[1], null)));
    }

    private static class Duration {
        private final BigInteger years;
        private final BigInteger months;
        private final BigInteger days;
        private final BigInteger hours;
        private final BigInteger minutes;
        private final BigDecimal seconds;

        Duration(boolean bl, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal) {
            if (bl) {
                this.years = bigInteger.negate();
                this.months = bigInteger2.negate();
                this.days = bigInteger3.negate();
                this.hours = bigInteger4.negate();
                this.minutes = bigInteger5.negate();
                this.seconds = bigDecimal.negate();
            } else {
                this.years = bigInteger;
                this.months = bigInteger2;
                this.days = bigInteger3;
                this.hours = bigInteger4;
                this.minutes = bigInteger5;
                this.seconds = bigDecimal;
            }
        }

        BigInteger getYears() {
            return this.years;
        }

        BigInteger getMonths() {
            return this.months;
        }

        BigInteger getDays() {
            return this.days;
        }

        BigInteger getHours() {
            return this.hours;
        }

        BigInteger getMinutes() {
            return this.minutes;
        }

        BigDecimal getSeconds() {
            return this.seconds;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Duration)) {
                return false;
            }
            Duration duration = (Duration)object;
            return this.years.equals(duration.years) && this.months.equals(duration.months) && this.days.equals(duration.days) && this.hours.equals(duration.hours) && this.minutes.equals(duration.minutes) && this.seconds.compareTo(duration.seconds) == 0;
        }

        public int hashCode() {
            return this.years.hashCode() ^ this.months.hashCode() ^ this.days.hashCode() ^ this.hours.hashCode() ^ this.minutes.hashCode() ^ this.seconds.hashCode();
        }
    }
}

