/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters.parser;

import java.math.BigDecimal;
import org.joda.time.Instant;
import org.logstash.filters.parser.TimestampParser;

public class UnixMillisEpochParser
implements TimestampParser {
    private static long MAX_EPOCH_MILLISECONDS = 2147483647000L;

    @Override
    public Instant parse(String value) {
        return this.parse(Long.parseLong(value));
    }

    @Override
    public Instant parse(Long value) {
        return new Instant((Object)value);
    }

    @Override
    public Instant parse(Double value) {
        return this.parse(value.longValue());
    }

    @Override
    public Instant parseWithTimeZone(String value, String timezone) {
        return this.parse(value);
    }

    @Override
    public Instant parse(BigDecimal value) {
        long lv = value.longValue();
        if (lv > MAX_EPOCH_MILLISECONDS) {
            throw new IllegalArgumentException("Cannot parse date for value larger than UNIX epoch maximum seconds");
        }
        return new Instant(lv);
    }
}

