/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.DecimalValue;

public abstract class AbstractStaticContext
implements StaticContext {
    private String baseURI = null;
    private Configuration config;
    private LocationMap locationMap = new LocationMap();
    private String defaultCollationName;
    private FunctionLibraryList libraryList = new FunctionLibraryList();
    private String defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
    private String defaultElementNamespace = "";
    private DecimalFormatManager decimalFormatManager = null;
    private KeyManager keyManager = null;
    private boolean backwardsCompatible = false;
    private DecimalValue xpathLanguageLevel = DecimalValue.THREE;
    private boolean schemaAware = false;
    protected boolean usingDefaultFunctionLibrary;

    protected void setConfiguration(Configuration config) {
        this.config = config;
        this.defaultCollationName = config.getDefaultCollationName();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setSchemaAware(boolean aware) {
        this.schemaAware = aware;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }

    protected final void setDefaultFunctionLibrary() {
        FunctionLibraryList lib = new FunctionLibraryList();
        int features = this.getXPathLanguageLevel().equals(DecimalValue.THREE) ? 17 : 1;
        lib.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(features));
        lib.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
        lib.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        lib.addFunctionLibrary(this.config.getIntegratedFunctionLibrary());
        this.config.addExtensionBinders(lib);
        this.setFunctionLibrary(lib);
    }

    protected final void addFunctionLibrary(FunctionLibrary library) {
        this.libraryList.addFunctionLibrary(library);
    }

    public int getHostLanguage() {
        return 54;
    }

    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration());
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void setLocationMap(LocationMap locationMap) {
        this.locationMap = locationMap;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.libraryList;
    }

    public void setFunctionLibrary(FunctionLibraryList lib) {
        this.libraryList = lib;
        this.usingDefaultFunctionLibrary = false;
    }

    public void declareCollation(String name, StringCollator comparator, boolean isDefault) {
        this.getConfiguration().registerCollation(name, comparator);
        if (isDefault) {
            this.defaultCollationName = name;
        }
    }

    public StringCollator getCollation(String name) {
        if (name == null) {
            name = this.defaultCollationName;
        }
        try {
            return this.getConfiguration().getCollation(name);
        }
        catch (XPathException e) {
            this.issueWarning(e.getMessage(), null);
            return null;
        }
    }

    public void setDefaultCollationName(String collationName) {
        this.defaultCollationName = collationName;
    }

    public String getDefaultCollationName() {
        return this.defaultCollationName;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public void issueWarning(String s, SourceLocator locator) {
        this.config.getErrorListener().warning(new XPathException(s));
    }

    public String getSystemId() {
        return "";
    }

    public int getLineNumber() {
        return -1;
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setDefaultElementNamespace(String uri) {
        this.defaultElementNamespace = uri;
    }

    public void setDefaultFunctionNamespace(String uri) {
        this.defaultFunctionNamespace = uri;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setXPathLanguageLevel(DecimalValue level) {
        this.xpathLanguageLevel = level;
        if (this.usingDefaultFunctionLibrary) {
            FunctionLibraryList liblist = (FunctionLibraryList)this.getFunctionLibrary();
            List<FunctionLibrary> list = liblist.getLibraryList();
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof SystemFunctionLibrary)) continue;
                int features = this.getXPathLanguageLevel().equals(DecimalValue.THREE) ? 17 : 1;
                list.set(i, SystemFunctionLibrary.getSystemFunctionLibrary(features));
                break;
            }
        }
    }

    public DecimalValue getXPathLanguageLevel() {
        return this.xpathLanguageLevel;
    }

    public void setBackwardsCompatibilityMode(boolean option) {
        this.backwardsCompatible = option;
    }

    public boolean isInBackwardsCompatibleMode() {
        return this.backwardsCompatible;
    }

    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        return type.getFingerprint() != 565 || this.config.getXsdVersion() == 11;
    }

    public void setDecimalFormatManager(DecimalFormatManager manager) {
        this.decimalFormatManager = manager;
    }

    public ItemType getRequiredContextItemType() {
        return AnyItemType.getInstance();
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = new KeyManager(this.getConfiguration());
        }
        return this.keyManager;
    }

    public LocationProvider getLocationProvider() {
        return this.locationMap;
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }
}

