/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Iterator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InScopePrefixes
extends SystemFunctionCall
implements Callable {
    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        NodeInfo element = (NodeInfo)this.argument[0].evaluateItem(context);
        Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(element);
        return this.sequenceIterator(iter, context);
    }

    public SequenceIterator sequenceIterator(final Iterator<NamespaceBinding> iter, final XPathContext context) {
        return new SequenceIterator(){
            private int position = 0;

            public SequenceIterator getAnother() throws XPathException {
                return InScopePrefixes.this.iterate(context);
            }

            public int getProperties() {
                return 0;
            }

            public StringValue next() throws XPathException {
                if (this.position == 0) {
                    ++this.position;
                    return new StringValue("xml");
                }
                if (iter.hasNext()) {
                    String prefix = ((NamespaceBinding)iter.next()).getPrefix();
                    StringValue current = prefix.length() == 0 ? StringValue.EMPTY_STRING : new StringValue(prefix, BuiltInAtomicType.NCNAME);
                    ++this.position;
                    return current;
                }
                this.position = -1;
                return null;
            }

            public void close() {
            }
        };
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo element = (NodeInfo)arguments[0].head();
        Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(element);
        return SequenceTool.toLazySequence(this.sequenceIterator(iter, context));
    }
}

