/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.websocket;

import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnectionBroadcaster;
import com.sun.star.io.XStreamListener;
import com.sun.star.lib.connections.websocket.ConnectionDescriptor;
import com.sun.star.uno.RuntimeException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WebsocketConnection
extends WebSocketClient
implements XConnection,
XConnectionBroadcaster {
    public static final boolean DEBUG = false;
    static final byte[] outgoingPrefix = new byte[]{117, 114, 112, 32};
    protected String _description;
    protected InputStream _inputStream;
    protected OutputStream _inputStreamWriter;
    protected ByteArrayOutputStream _outputStream;
    protected ArrayList<XStreamListener> _listeners;

    public WebsocketConnection(String string, ConnectionDescriptor connectionDescriptor) throws IOException, URISyntaxException, InterruptedException {
        super(new URI(connectionDescriptor.getURL()));
        this._description = string;
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        this._inputStream = new BufferedInputStream(pipedInputStream);
        this._inputStreamWriter = pipedOutputStream;
        this._outputStream = new ByteArrayOutputStream();
        this._listeners = new ArrayList();
        this.connectBlocking();
    }

    @Override
    public void addStreamListener(XStreamListener xStreamListener) throws RuntimeException {
        this._listeners.add(xStreamListener);
    }

    @Override
    public void removeStreamListener(XStreamListener xStreamListener) throws RuntimeException {
        this._listeners.remove(xStreamListener);
    }

    private void notifyListeners_open() {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.started();
        }
    }

    private void notifyListeners_close() {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.closed();
        }
    }

    private void notifyListeners_error(com.sun.star.uno.Exception exception) {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.error(exception);
        }
    }

    @Override
    public int read(byte[][] byArray, int n) throws com.sun.star.io.IOException, RuntimeException {
        String string = null;
        int n2 = 0;
        byArray[0] = new byte[n];
        try {
            int n3;
            this._inputStreamWriter.flush();
            do {
                if ((n3 = this._inputStream.read(byArray[0], n2, n - n2)) != -1) continue;
                string = "EOF reached - " + this.getDescription();
            } while ((n2 += n3) >= 0 && n2 < n && n3 >= 0);
        }
        catch (IOException iOException) {
            string = iOException.toString();
        }
        if (string != null) {
            com.sun.star.io.IOException iOException = new com.sun.star.io.IOException(string);
            this.notifyListeners_error(iOException);
            throw iOException;
        }
        return n2;
    }

    @Override
    public void write(byte[] byArray) throws com.sun.star.io.IOException, RuntimeException {
        try {
            this._outputStream.write(byArray);
        }
        catch (IOException iOException) {
            com.sun.star.io.IOException iOException2 = new com.sun.star.io.IOException(iOException);
            this.notifyListeners_error(iOException2);
            throw iOException2;
        }
    }

    @Override
    public void flush() throws com.sun.star.io.IOException, RuntimeException {
        byte[] byArray = this._outputStream.toByteArray();
        this._outputStream.reset();
        byte[] byArray2 = new byte[byArray.length + outgoingPrefix.length];
        System.arraycopy(outgoingPrefix, 0, byArray2, 0, outgoingPrefix.length);
        System.arraycopy(byArray, 0, byArray2, outgoingPrefix.length, byArray.length);
        this.send(byArray2);
    }

    @Override
    public void close() throws RuntimeException {
        super.close();
    }

    @Override
    public String getDescription() throws RuntimeException {
        return this._description;
    }

    public void onOpen(ServerHandshake serverHandshake) {
        this.notifyListeners_open();
    }

    public void onClose(int n, String string, boolean bl) {
        this.notifyListeners_close();
    }

    public void onMessage(String string) {
        String[] stringArray = string.split(": ", 2);
        if (stringArray.length != 2) {
            this.notifyListeners_error(new com.sun.star.uno.Exception(new ProtocolException(String.format("Received URP/WS message (%s) without a type specifier. Messages must be proceeded by 'urp: '", string))));
            return;
        }
        String string2 = stringArray[0];
        if (!string2.equals("urp")) {
            return;
        }
        byte[] byArray = stringArray[1].getBytes(StandardCharsets.UTF_8);
        try {
            this._inputStreamWriter.write(byArray);
            this._inputStreamWriter.flush();
        }
        catch (IOException iOException) {
            this.notifyListeners_error(new com.sun.star.uno.Exception(iOException));
            return;
        }
    }

    public void onMessage(ByteBuffer byteBuffer) {
        int n;
        byte[] byArray = byteBuffer.array();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (n = 0; n < byArray.length - 1; ++n) {
            if (byArray[n] == 58 && byArray[n + 1] == 32) {
                bl = true;
                break;
            }
            stringBuffer.append((char)byArray[n]);
        }
        if (!bl) {
            this.notifyListeners_error(new com.sun.star.uno.Exception(new ProtocolException(String.format("Received URP/WS message (%s) without a type specifier. Binary messages must be proceeded by 'urp: '", byteBuffer))));
            return;
        }
        String string = stringBuffer.toString();
        int n2 = n + 2;
        if (!string.equals("urp")) {
            return;
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, n2, byArray.length);
        try {
            this._inputStreamWriter.write(byArray2);
            this._inputStreamWriter.flush();
        }
        catch (IOException iOException) {
            this.notifyListeners_error(new com.sun.star.uno.Exception(iOException));
            return;
        }
    }

    public void onError(Exception exception) {
        this.notifyListeners_error(new com.sun.star.uno.Exception(exception));
    }
}

