/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.resource;

import java.io.InputStream;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;

public class ClassloaderResourceData
extends AbstractResourceData {
    private ResourceKey key;
    private String resourcePath;
    private static final long serialVersionUID = 980009972320937886L;

    public ClassloaderResourceData(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
        String rawPath = (String)key.getIdentifier();
        this.resourcePath = rawPath.substring(6);
    }

    @Override
    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        InputStream stream = ObjectUtilities.getResourceAsStream((String)this.resourcePath, ClassloaderResourceData.class);
        if (stream == null) {
            throw new ResourceLoadingException("Resource is not available: " + this.resourcePath);
        }
        return stream;
    }

    @Override
    public Object getAttribute(String key) {
        if (key.equals("filename")) {
            return LoaderUtils.getFileName(this.resourcePath);
        }
        return null;
    }

    @Override
    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        return 0L;
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }
}

