/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.survey;

import java.awt.Paint;
import java.awt.Shape;
import java.io.Serializable;
import org.jfree.report.DataSourceException;
import org.jfree.report.expressions.ColumnAggregationExpression;
import org.jfree.report.modules.misc.survey.SurveyScale;

public class SurveyScaleExpression
extends ColumnAggregationExpression
implements Serializable {
    private Number rangeLowerBound;
    private Number rangeUpperBound;
    private Paint rangePaint;
    private Shape overrideShape;
    private boolean overrideShapeFilled;
    private int lowestValue;
    private int highestValue;

    @Override
    protected int getFieldListParameterPosition() {
        return 2;
    }

    public Number getRangeLowerBound() {
        return this.rangeLowerBound;
    }

    public void setRangeLowerBound(Number number) {
        this.rangeLowerBound = number;
    }

    public Number getRangeUpperBound() {
        return this.rangeUpperBound;
    }

    public void setRangeUpperBound(Number number) {
        this.rangeUpperBound = number;
    }

    public int getLowestValue() {
        return this.lowestValue;
    }

    public void setLowestValue(int n) {
        this.lowestValue = n;
    }

    public int getHighestValue() {
        return this.highestValue;
    }

    public void setHighestValue(int n) {
        this.highestValue = n;
    }

    public Shape getOverrideShape() {
        return this.overrideShape;
    }

    public void setOverrideShape(Shape shape) {
        this.overrideShape = shape;
    }

    public void setOverrideShapeFilled(boolean bl) {
        this.overrideShapeFilled = bl;
    }

    @Override
    public Object computeValue() throws DataSourceException {
        Number[] numberArray = (Number[])this.getFieldValues(Number.class);
        SurveyScale surveyScale = new SurveyScale(this.lowestValue, this.highestValue, numberArray);
        surveyScale.setRangeLowerBound(this.getRangeLowerBound());
        surveyScale.setRangeUpperBound(this.getRangeUpperBound());
        surveyScale.setRangePaint(this.rangePaint);
        if (this.overrideShape != null) {
            surveyScale.setShape(0, this.overrideShape);
            surveyScale.setShapeFilled(0, this.overrideShapeFilled);
        }
        return surveyScale;
    }

    public boolean isOverrideShapeFilled() {
        return this.overrideShapeFilled;
    }

    public Paint getRangePaint() {
        return this.rangePaint;
    }

    public void setRangePaint(Paint paint) {
        this.rangePaint = paint;
    }
}

