/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.report.flow;

import java.beans.IntrospectionException;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.expressions.FormulaFunction;
import org.jfree.report.modules.factories.report.flow.TypedPropertyReadHandler;
import org.jfree.report.util.CharacterEntityParser;
import org.jfree.report.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractExpressionReadHandler
extends AbstractXmlReadHandler {
    private Expression expression;
    private BeanUtility expressionBeanUtility;
    private CharacterEntityParser characterEntityParser = CharacterEntityParser.createXMLEntityParser();

    protected String getDefaultClassName() {
        return null;
    }

    protected void startParsing(Attributes attributes) throws SAXException {
        String string = attributes.getValue(this.getUri(), "name");
        String string2 = attributes.getValue(this.getUri(), "class");
        String string3 = attributes.getValue(this.getUri(), "formula");
        if (string2 == null) {
            if (string3 != null) {
                String string4 = attributes.getValue(this.getUri(), "initial");
                if (string4 != null) {
                    FormulaFunction formulaFunction = new FormulaFunction();
                    formulaFunction.setInitial(string4);
                    formulaFunction.setFormula(string3);
                    this.expression = formulaFunction;
                } else {
                    FormulaExpression formulaExpression = new FormulaExpression();
                    formulaExpression.setFormula(string3);
                    this.expression = formulaExpression;
                }
            } else {
                string2 = this.getDefaultClassName();
                if (string2 == null) {
                    throw new ParseException("Required attribute 'class' is missing.", this.getRootHandler().getDocumentLocator());
                }
            }
        }
        if (this.expression == null) {
            this.expression = (Expression)ObjectUtilities.loadAndInstantiate((String)string2, AbstractExpressionReadHandler.class, Expression.class);
            if (this.expression == null) {
                throw new ParseException("Expression '" + string2 + "' is not valid. The specified class is not an expression or function.", this.getRootHandler().getDocumentLocator());
            }
        }
        this.expression.setName(string);
        this.expression.setDeepTraversing("true".equals(attributes.getValue(this.getUri(), "deep-traversing")));
        this.expression.setPrecompute("true".equals(attributes.getValue(this.getUri(), "precompute")));
        this.expression.setPreserve("true".equals(attributes.getValue(this.getUri(), "preserve")));
        try {
            this.expressionBeanUtility = new BeanUtility(this.expression);
        }
        catch (ClassCastException classCastException) {
            throw new ParseException("Expression '" + string2 + "' is not valid. The specified class is not an expression or function.", (Exception)classCastException, this.getRootHandler().getDocumentLocator());
        }
        catch (IntrospectionException introspectionException) {
            throw new ParseException("Expression '" + string2 + "' is not valid. Introspection failed for this expression.", (Exception)introspectionException, this.getRootHandler().getDocumentLocator());
        }
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        if (!this.isSameNamespace(string)) {
            return null;
        }
        if (string2.equals("property")) {
            return new TypedPropertyReadHandler(this.expressionBeanUtility, this.expression.getName(), this.characterEntityParser);
        }
        return null;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Object getObject() throws SAXException {
        return this.expression;
    }
}

