/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jfree.layouting.input.style.keys.color.CSSSystemColors;
import org.jfree.layouting.input.style.keys.color.HtmlColors;
import org.jfree.layouting.input.style.keys.color.SVGColors;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSValue;

public class ColorUtil {
    private static final float ONE_THIRD = 0.33333334f;

    private ColorUtil() {
    }

    public static float[] hslToRGB(int n, float f, float f2) {
        float f3;
        int n2 = ColorUtil.normalizeHue(n);
        float f4 = f;
        if (f4 > 100.0f) {
            f4 = 100.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if ((f3 = f2) > 100.0f) {
            f3 = 100.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        float f5 = (double)f3 <= 0.5 ? f3 * (f4 + 1.0f) : f3 + f4 - f3 * f4;
        float f6 = f3 * 2.0f - f5;
        float f7 = ColorUtil.hueToRGB(f6, f5, (float)n2 + 0.33333334f);
        float f8 = ColorUtil.hueToRGB(f6, f5, n2);
        float f9 = ColorUtil.hueToRGB(f6, f5, (float)n2 - 0.33333334f);
        return new float[]{f7, f8, f9};
    }

    private static float hueToRGB(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        }
        if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        if (f3 * 6.0f < 1.0f) {
            return f + (f2 - f) * f3 * 6.0f;
        }
        if (f3 * 2.0f < 1.0f) {
            return f2;
        }
        if (f3 * 3.0f < 2.0f) {
            return f + (f2 - f) * (0.6666667f - f3) * 6.0f;
        }
        return f;
    }

    private static int normalizeHue(int n) {
        return (n % 360 + 360) % 360;
    }

    public static CSSValue parseColor(String string) {
        CSSValue cSSValue = ColorUtil.parseIdentColor(string);
        if (cSSValue != null) {
            return cSSValue;
        }
        try {
            if (string.length() == 4) {
                string = "#" + string.charAt(1) + string.charAt(1) + string.charAt(2) + string.charAt(2) + string.charAt(3) + string.charAt(3);
            }
            Integer n = Integer.decode(string);
            return new CSSColorValue(n, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static CSSValue parseIdentColor(String string) {
        if (CSSSystemColors.CURRENT_COLOR.getCSSText().equalsIgnoreCase(string)) {
            return CSSSystemColors.CURRENT_COLOR;
        }
        CSSColorValue cSSColorValue = ColorUtil.parseColorFromClass(string, HtmlColors.class);
        if (cSSColorValue != null) {
            return cSSColorValue;
        }
        CSSColorValue cSSColorValue2 = ColorUtil.parseColorFromClass(string, SVGColors.class);
        if (cSSColorValue2 != null) {
            return cSSColorValue2;
        }
        CSSColorValue cSSColorValue3 = ColorUtil.parseColorFromClass(string, CSSSystemColors.class);
        if (cSSColorValue3 != null) {
            return cSSColorValue3;
        }
        return null;
    }

    private static CSSColorValue parseColorFromClass(String string, Class clazz) {
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                Field field = fieldArray[i];
                if (!field.getName().equalsIgnoreCase(string) || !CSSColorValue.class.isAssignableFrom(field.getType()) || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                return (CSSColorValue)field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

