/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import java.util.ArrayList;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.NodeLayoutProperties;
import org.jfree.layouting.renderer.model.PlaceholderRenderNode;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;

public class NormalFlowRenderBox
extends BlockRenderBox {
    private Object placeHolderId;
    private PlaceholderRenderNode placeHolder = new PlaceholderRenderNode();
    private ArrayList subFlows;

    public NormalFlowRenderBox(BoxDefinition boxDefinition) {
        super(boxDefinition);
        this.placeHolderId = this.getPlaceHolder().getInstanceId();
        this.subFlows = new ArrayList();
        NodeLayoutProperties nodeLayoutProperties = this.getNodeLayoutProperties();
        nodeLayoutProperties.setNamespace("http://jfreereport.sourceforge.net/namespaces/layout");
        nodeLayoutProperties.setTagName("normal-flow");
    }

    @Override
    public void appyStyle(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        super.appyStyle(layoutContext, outputProcessorMetaData);
        NodeLayoutProperties nodeLayoutProperties = this.getNodeLayoutProperties();
        nodeLayoutProperties.setNamespace("http://jfreereport.sourceforge.net/namespaces/layout");
        nodeLayoutProperties.setTagName("normal-flow");
    }

    public PlaceholderRenderNode getPlaceHolder() {
        return this.placeHolder;
    }

    @Override
    public void addChild(RenderNode renderNode) {
        if (!(renderNode instanceof BlockRenderBox)) {
            throw new IllegalStateException("This cannot be.");
        }
        super.addChild(renderNode);
    }

    public void addFlow(NormalFlowRenderBox normalFlowRenderBox) {
        this.subFlows.add(normalFlowRenderBox);
    }

    public NormalFlowRenderBox[] getFlows() {
        return this.subFlows.toArray(new NormalFlowRenderBox[this.subFlows.size()]);
    }

    public NormalFlowRenderBox getFlow(int n) {
        return (NormalFlowRenderBox)this.subFlows.get(n);
    }

    public int getFlowCount() {
        return this.subFlows.size();
    }

    @Override
    public RenderNode hibernate() {
        NormalFlowRenderBox normalFlowRenderBox = (NormalFlowRenderBox)super.hibernate();
        normalFlowRenderBox.subFlows = new ArrayList(this.subFlows.size());
        for (int i = 0; i < this.subFlows.size(); ++i) {
            NormalFlowRenderBox normalFlowRenderBox2 = (NormalFlowRenderBox)this.subFlows.get(i);
            normalFlowRenderBox.subFlows.add(normalFlowRenderBox2.derive(true));
            normalFlowRenderBox2.placeHolder = (PlaceholderRenderNode)this.findNodeById(normalFlowRenderBox2.placeHolderId);
        }
        normalFlowRenderBox.placeHolder = null;
        return normalFlowRenderBox;
    }

    @Override
    public RenderNode derive(boolean bl) {
        NormalFlowRenderBox normalFlowRenderBox = (NormalFlowRenderBox)super.derive(bl);
        if (bl) {
            normalFlowRenderBox.subFlows = new ArrayList(this.subFlows.size());
            for (int i = 0; i < this.subFlows.size(); ++i) {
                NormalFlowRenderBox normalFlowRenderBox2 = (NormalFlowRenderBox)this.subFlows.get(i);
                normalFlowRenderBox.subFlows.add(normalFlowRenderBox2.derive(true));
                normalFlowRenderBox2.placeHolder = (PlaceholderRenderNode)this.findNodeById(normalFlowRenderBox2.placeHolderId);
            }
            normalFlowRenderBox.placeHolder = null;
        } else {
            normalFlowRenderBox.placeHolder = (PlaceholderRenderNode)this.placeHolder.derive(true);
            normalFlowRenderBox.subFlows = new ArrayList();
        }
        return normalFlowRenderBox;
    }

    @Override
    public RenderNode deriveFrozen(boolean bl) {
        NormalFlowRenderBox normalFlowRenderBox = (NormalFlowRenderBox)super.deriveFrozen(bl);
        if (bl) {
            normalFlowRenderBox.subFlows = new ArrayList(this.subFlows.size());
            for (int i = 0; i < this.subFlows.size(); ++i) {
                NormalFlowRenderBox normalFlowRenderBox2 = (NormalFlowRenderBox)this.subFlows.get(i);
                normalFlowRenderBox.subFlows.add(normalFlowRenderBox2.deriveFrozen(true));
                normalFlowRenderBox2.placeHolder = (PlaceholderRenderNode)this.findNodeById(normalFlowRenderBox2.placeHolderId);
            }
            normalFlowRenderBox.placeHolder = null;
        } else {
            normalFlowRenderBox.placeHolder = (PlaceholderRenderNode)this.placeHolder.deriveFrozen(true);
            normalFlowRenderBox.subFlows = new ArrayList();
        }
        return normalFlowRenderBox;
    }

    @Override
    public RenderBox getInsertationPoint() {
        for (int i = 0; i < this.subFlows.size(); ++i) {
            NormalFlowRenderBox normalFlowRenderBox = (NormalFlowRenderBox)this.subFlows.get(i);
            if (!normalFlowRenderBox.isOpen()) continue;
            return normalFlowRenderBox.getInsertationPoint();
        }
        return super.getInsertationPoint();
    }

    @Override
    public NormalFlowRenderBox getNormalFlow() {
        return this;
    }

    @Override
    public RenderNode findNodeById(Object object) {
        for (int i = 0; i < this.subFlows.size(); ++i) {
            RenderNode renderNode = (RenderNode)this.subFlows.get(i);
            RenderNode renderNode2 = renderNode.findNodeById(object);
            if (renderNode2 == null) continue;
            return renderNode2;
        }
        return super.findNodeById(object);
    }
}

