/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class DrawablePanel
extends JPanel {
    private DrawableWrapper drawable;

    public DrawablePanel() {
        this.setOpaque(false);
    }

    public DrawableWrapper getDrawable() {
        return this.drawable;
    }

    public void setDrawableAsRawObject(Object object) {
        if (object == null) {
            this.setDrawable(null);
        } else if (object instanceof DrawableWrapper) {
            this.setDrawable((DrawableWrapper)object);
        } else {
            this.setDrawable(new DrawableWrapper(object));
        }
    }

    public void setDrawable(DrawableWrapper drawableWrapper) {
        this.drawable = drawableWrapper;
        this.revalidate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.drawable == null) {
            return new Dimension(0, 0);
        }
        return this.drawable.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.drawable == null) {
            return new Dimension(0, 0);
        }
        return this.drawable.getPreferredSize();
    }

    @Override
    public boolean isOpaque() {
        if (this.drawable == null) {
            return false;
        }
        return super.isOpaque();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.drawable == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create(0, 0, this.getWidth(), this.getHeight());
        this.drawable.draw(graphics2D, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        graphics2D.dispose();
    }
}

