/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.content;

import java.net.URL;
import java.util.Date;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.statics.ExternalContentToken;
import org.jfree.layouting.layouter.content.statics.ResourceContentToken;
import org.jfree.layouting.layouter.content.statics.StaticTextToken;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;
import org.jfree.layouting.layouter.style.values.CSSResourceValue;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.ColorUtil;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class AttrValueFunction
implements ContentFunction {
    @Override
    public ContentToken evaluate(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSFunctionValue cSSFunctionValue) throws FunctionEvaluationException {
        CSSValue[] cSSValueArray = cSSFunctionValue.getParameters();
        if (cSSValueArray.length < 2) {
            throw new FunctionEvaluationException("The parsed attr() function needs at least two parameters.");
        }
        String string = FunctionUtilities.resolveString(layoutProcess, layoutElement, cSSValueArray[0]);
        String string2 = FunctionUtilities.resolveString(layoutProcess, layoutElement, cSSValueArray[1]);
        String string3 = null;
        if (cSSValueArray.length >= 3) {
            string3 = FunctionUtilities.resolveString(layoutProcess, layoutElement, cSSValueArray[2]);
        }
        AttributeMap attributeMap = layoutElement.getLayoutContext().getAttributes();
        if (string == null || "".equals(string)) {
            Object object = attributeMap.getAttribute(layoutElement.getLayoutContext().getNamespace(), string2);
            return this.convertValue(layoutProcess, object, string3);
        }
        if ("*".equals(string)) {
            Object object = attributeMap.getFirstAttribute(string2);
            return this.convertValue(layoutProcess, object, string3);
        }
        Object object = attributeMap.getAttribute(string, string2);
        return this.convertValue(layoutProcess, object, string3);
    }

    private ContentToken convertValue(LayoutProcess layoutProcess, Object object, String string) throws FunctionEvaluationException {
        if (object instanceof CSSValue) {
            throw new FunctionEvaluationException();
        }
        if (object instanceof String) {
            String string2 = (String)object;
            if ("length".equals(string)) {
                CSSNumericValue cSSNumericValue = FunctionUtilities.parseNumberValue(string2);
                return new StaticTextToken(cSSNumericValue.getCSSText());
            }
            if ("url".equals(string)) {
                CSSResourceValue cSSResourceValue = FunctionUtilities.loadResource(layoutProcess, string2);
                Resource resource = cSSResourceValue.getValue();
                return new ResourceContentToken(resource);
            }
            if ("color".equals(string)) {
                CSSValue cSSValue = ColorUtil.parseColor(string2);
                if (cSSValue == null) {
                    throw new FunctionEvaluationException();
                }
                return new StaticTextToken(cSSValue.getCSSText());
            }
            CSSValue cSSValue = FunctionUtilities.parseValue(layoutProcess, string2);
            if (cSSValue instanceof CSSResourceValue) {
                CSSResourceValue cSSResourceValue = (CSSResourceValue)cSSValue;
                Resource resource = cSSResourceValue.getValue();
                return new ResourceContentToken(resource);
            }
            if (cSSValue instanceof CSSStringValue) {
                CSSStringValue cSSStringValue = (CSSStringValue)cSSValue;
                return new StaticTextToken(cSSStringValue.getValue());
            }
            return new StaticTextToken(cSSValue.getCSSText());
        }
        if (object instanceof URL) {
            CSSResourceValue cSSResourceValue = FunctionUtilities.loadResource(layoutProcess, object);
            Resource resource = cSSResourceValue.getValue();
            return new ResourceContentToken(resource);
        }
        if (object instanceof Resource) {
            return new ResourceContentToken((Resource)object);
        }
        if (object instanceof ResourceKey) {
            CSSResourceValue cSSResourceValue = FunctionUtilities.loadResource(layoutProcess, object);
            Resource resource = cSSResourceValue.getValue();
            return new ResourceContentToken(resource);
        }
        if (object instanceof Date) {
            return new StaticTextToken(String.valueOf(object));
        }
        if (object instanceof Number) {
            return new StaticTextToken(String.valueOf(object));
        }
        return new ExternalContentToken(object);
    }
}

