/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.function.text.MidFunction;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class LeftFunction
implements Function {
    private static final long serialVersionUID = 7929942586373275084L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int length;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        String text = typeRegistry.convertToText(textType, textValue);
        if (parameterCount == 2) {
            Object lengthValue;
            Type lengthType = parameters.getType(1);
            Number lengthConv = typeRegistry.convertToNumber(lengthType, lengthValue = parameters.getValue(1));
            if (lengthConv.doubleValue() < 0.0) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            length = lengthConv.intValue();
        } else {
            length = 1;
        }
        if (text == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(TextType.TYPE, MidFunction.process(text, 1, length));
    }

    @Override
    public String getCanonicalName() {
        return "LEFT";
    }
}

