/*
 * Codepage definitions for libevtx
 *
 * Copyright (C) 2011-2019, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBEVTX_CODEPAGE_H )
#define _LIBEVTX_CODEPAGE_H

#include <libevtx/types.h>

#if defined( __cplusplus )
extern "C" {
#endif

/* The codepage definitions
 */
enum LIBEVTX_CODEPAGES
{
	LIBEVTX_CODEPAGE_ASCII				= 20127,

	LIBEVTX_CODEPAGE_ISO_8859_1			= 28591,
	LIBEVTX_CODEPAGE_ISO_8859_2			= 28592,
	LIBEVTX_CODEPAGE_ISO_8859_3			= 28593,
	LIBEVTX_CODEPAGE_ISO_8859_4			= 28594,
	LIBEVTX_CODEPAGE_ISO_8859_5			= 28595,
	LIBEVTX_CODEPAGE_ISO_8859_6			= 28596,
	LIBEVTX_CODEPAGE_ISO_8859_7			= 28597,
	LIBEVTX_CODEPAGE_ISO_8859_8			= 28598,
	LIBEVTX_CODEPAGE_ISO_8859_9			= 28599,
	LIBEVTX_CODEPAGE_ISO_8859_10			= 28600,
	LIBEVTX_CODEPAGE_ISO_8859_11			= 28601,
	LIBEVTX_CODEPAGE_ISO_8859_13			= 28603,
	LIBEVTX_CODEPAGE_ISO_8859_14			= 28604,
	LIBEVTX_CODEPAGE_ISO_8859_15			= 28605,
	LIBEVTX_CODEPAGE_ISO_8859_16			= 28606,

	LIBEVTX_CODEPAGE_KOI8_R				= 20866,
	LIBEVTX_CODEPAGE_KOI8_U				= 21866,

	LIBEVTX_CODEPAGE_WINDOWS_874			= 874,
	LIBEVTX_CODEPAGE_WINDOWS_932			= 932,
	LIBEVTX_CODEPAGE_WINDOWS_936			= 936,
	LIBEVTX_CODEPAGE_WINDOWS_949			= 949,
	LIBEVTX_CODEPAGE_WINDOWS_950			= 950,
	LIBEVTX_CODEPAGE_WINDOWS_1250			= 1250,
	LIBEVTX_CODEPAGE_WINDOWS_1251			= 1251,
	LIBEVTX_CODEPAGE_WINDOWS_1252			= 1252,
	LIBEVTX_CODEPAGE_WINDOWS_1253			= 1253,
	LIBEVTX_CODEPAGE_WINDOWS_1254			= 1254,
	LIBEVTX_CODEPAGE_WINDOWS_1255			= 1255,
	LIBEVTX_CODEPAGE_WINDOWS_1256			= 1256,
	LIBEVTX_CODEPAGE_WINDOWS_1257			= 1257,
	LIBEVTX_CODEPAGE_WINDOWS_1258			= 1258
};

#define LIBEVTX_CODEPAGE_US_ASCII			LIBEVTX_CODEPAGE_ASCII

#define LIBEVTX_CODEPAGE_ISO_WESTERN_EUROPEAN		LIBEVTX_CODEPAGE_ISO_8859_1
#define LIBEVTX_CODEPAGE_ISO_CENTRAL_EUROPEAN		LIBEVTX_CODEPAGE_ISO_8859_2
#define LIBEVTX_CODEPAGE_ISO_SOUTH_EUROPEAN		LIBEVTX_CODEPAGE_ISO_8859_3
#define LIBEVTX_CODEPAGE_ISO_NORTH_EUROPEAN		LIBEVTX_CODEPAGE_ISO_8859_4
#define LIBEVTX_CODEPAGE_ISO_CYRILLIC			LIBEVTX_CODEPAGE_ISO_8859_5
#define LIBEVTX_CODEPAGE_ISO_ARABIC			LIBEVTX_CODEPAGE_ISO_8859_6
#define LIBEVTX_CODEPAGE_ISO_GREEK			LIBEVTX_CODEPAGE_ISO_8859_7
#define LIBEVTX_CODEPAGE_ISO_HEBREW			LIBEVTX_CODEPAGE_ISO_8859_8
#define LIBEVTX_CODEPAGE_ISO_TURKISH			LIBEVTX_CODEPAGE_ISO_8859_9
#define LIBEVTX_CODEPAGE_ISO_NORDIC			LIBEVTX_CODEPAGE_ISO_8859_10
#define LIBEVTX_CODEPAGE_ISO_THAI			LIBEVTX_CODEPAGE_ISO_8859_11
#define LIBEVTX_CODEPAGE_ISO_BALTIC			LIBEVTX_CODEPAGE_ISO_8859_13
#define LIBEVTX_CODEPAGE_ISO_CELTIC			LIBEVTX_CODEPAGE_ISO_8859_14

#define LIBEVTX_CODEPAGE_ISO_LATIN_1			LIBEVTX_CODEPAGE_ISO_8859_1
#define LIBEVTX_CODEPAGE_ISO_LATIN_2			LIBEVTX_CODEPAGE_ISO_8859_2
#define LIBEVTX_CODEPAGE_ISO_LATIN_3			LIBEVTX_CODEPAGE_ISO_8859_3
#define LIBEVTX_CODEPAGE_ISO_LATIN_4			LIBEVTX_CODEPAGE_ISO_8859_4
#define LIBEVTX_CODEPAGE_ISO_LATIN_5			LIBEVTX_CODEPAGE_ISO_8859_9
#define LIBEVTX_CODEPAGE_ISO_LATIN_6			LIBEVTX_CODEPAGE_ISO_8859_10
#define LIBEVTX_CODEPAGE_ISO_LATIN_7			LIBEVTX_CODEPAGE_ISO_8859_13
#define LIBEVTX_CODEPAGE_ISO_LATIN_8			LIBEVTX_CODEPAGE_ISO_8859_14
#define LIBEVTX_CODEPAGE_ISO_LATIN_9			LIBEVTX_CODEPAGE_ISO_8859_15
#define LIBEVTX_CODEPAGE_ISO_LATIN_10			LIBEVTX_CODEPAGE_ISO_8859_16

#define LIBEVTX_CODEPAGE_KOI8_RUSSIAN			LIBEVTX_CODEPAGE_KOI8_R
#define LIBEVTX_CODEPAGE_KOI8_UKRAINIAN			LIBEVTX_CODEPAGE_KOI8_U

#define LIBEVTX_CODEPAGE_WINDOWS_THAI			LIBEVTX_CODEPAGE_WINDOWS_874
#define LIBEVTX_CODEPAGE_WINDOWS_JAPANESE		LIBEVTX_CODEPAGE_WINDOWS_932
#define LIBEVTX_CODEPAGE_WINDOWS_CHINESE_SIMPLIFIED	LIBEVTX_CODEPAGE_WINDOWS_936
#define LIBEVTX_CODEPAGE_WINDOWS_KOREAN			LIBEVTX_CODEPAGE_WINDOWS_949
#define LIBEVTX_CODEPAGE_WINDOWS_CHINESE_TRADITIONAL	LIBEVTX_CODEPAGE_WINDOWS_950
#define LIBEVTX_CODEPAGE_WINDOWS_CENTRAL_EUROPEAN	LIBEVTX_CODEPAGE_WINDOWS_1250
#define LIBEVTX_CODEPAGE_WINDOWS_CYRILLIC		LIBEVTX_CODEPAGE_WINDOWS_1251
#define LIBEVTX_CODEPAGE_WINDOWS_WESTERN_EUROPEAN	LIBEVTX_CODEPAGE_WINDOWS_1252
#define LIBEVTX_CODEPAGE_WINDOWS_GREEK			LIBEVTX_CODEPAGE_WINDOWS_1253
#define LIBEVTX_CODEPAGE_WINDOWS_TURKISH		LIBEVTX_CODEPAGE_WINDOWS_1254
#define LIBEVTX_CODEPAGE_WINDOWS_HEBREW			LIBEVTX_CODEPAGE_WINDOWS_1255
#define LIBEVTX_CODEPAGE_WINDOWS_ARABIC			LIBEVTX_CODEPAGE_WINDOWS_1256
#define LIBEVTX_CODEPAGE_WINDOWS_BALTIC			LIBEVTX_CODEPAGE_WINDOWS_1257
#define LIBEVTX_CODEPAGE_WINDOWS_VIETNAMESE		LIBEVTX_CODEPAGE_WINDOWS_1258

#if defined( __cplusplus )
}
#endif

#endif /* !defined( _LIBEVTX_CODEPAGE_H ) */

