/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;

public class ScopeMappedUtil {
    public static ClientMappingsRepresentation toClientMappingsRepresentation(ClientModel client, ScopeContainerModel scopeContainer) {
        List roles = KeycloakModelUtils.getClientScopeMappingsStream((ClientModel)client, (ScopeContainerModel)scopeContainer).map(role -> ModelToRepresentation.toBriefRepresentation((RoleModel)role)).collect(Collectors.toList());
        if (roles.isEmpty()) {
            return null;
        }
        ClientMappingsRepresentation mappings = new ClientMappingsRepresentation();
        mappings.setId(client.getId());
        mappings.setClient(client.getClientId());
        mappings.setMappings(roles);
        return mappings;
    }
}

