/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.Config;
import org.keycloak.KeyPairVerifier;
import org.keycloak.authentication.CredentialRegistrator;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.client.clienttype.ClientTypeManager;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.email.EmailAuthenticator;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.exportimport.ClientDescriptionConverter;
import org.keycloak.exportimport.ClientDescriptionConverterFactory;
import org.keycloak.exportimport.ExportAdapter;
import org.keycloak.exportimport.ExportOptions;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.organization.admin.resource.OrganizationsResource;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AttackDetectionResource;
import org.keycloak.services.resources.admin.AuthenticationManagementResource;
import org.keycloak.services.resources.admin.ClientInitialAccessResource;
import org.keycloak.services.resources.admin.ClientPoliciesResource;
import org.keycloak.services.resources.admin.ClientProfilesResource;
import org.keycloak.services.resources.admin.ClientRegistrationPolicyResource;
import org.keycloak.services.resources.admin.ClientScopesResource;
import org.keycloak.services.resources.admin.ClientTypesResource;
import org.keycloak.services.resources.admin.ClientsResource;
import org.keycloak.services.resources.admin.ComponentResource;
import org.keycloak.services.resources.admin.GroupsResource;
import org.keycloak.services.resources.admin.IdentityProvidersResource;
import org.keycloak.services.resources.admin.KeyResource;
import org.keycloak.services.resources.admin.RealmLocalizationResource;
import org.keycloak.services.resources.admin.RoleByIdResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.UsersResource;
import org.keycloak.services.resources.admin.ext.AdminRealmResourceProvider;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.fgap.AdminPermissionManagement;
import org.keycloak.services.resources.admin.fgap.AdminPermissions;
import org.keycloak.services.util.DateUtil;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.ExportImportManager;
import org.keycloak.storage.StoreSyncEvent;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.GroupUtils;
import org.keycloak.utils.ProfileHelper;
import org.keycloak.utils.ReservedCharValidator;
import org.keycloak.utils.SMTPUtil;

@Extension(name="x-smallrye-profile-admin", value="")
public class RealmAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected final AdminPermissionEvaluator auth;
    protected final RealmModel realm;
    private final AdminEventBuilder adminEvent;
    protected final KeycloakSession session;
    protected final ClientConnection connection;
    protected final HttpHeaders headers;

    public RealmAdminResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
        this.connection = session.getContext().getConnection();
        this.adminEvent = adminEvent.resource(ResourceType.REALM);
        this.headers = session.getContext().getRequestHeaders();
    }

    @Path(value="client-description-converter")
    @Consumes(value={"application/json", "application/xml", "text/plain"})
    @POST
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Base path for importing clients under this realm.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientRepresentation.class))}), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public ClientRepresentation convertClientDescription(String description) {
        this.auth.clients().requireManage();
        if (this.realm == null) {
            throw new NotFoundException("Realm not found.");
        }
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ClientDescriptionConverter.class).map(ClientDescriptionConverterFactory.class::cast).filter(factory -> factory.isSupported(description)).map(factory -> ((ClientDescriptionConverter)factory.create(this.session)).convertToInternal(description)).findFirst().orElseThrow(() -> new BadRequestException("Unsupported format"));
    }

    @Path(value="attack-detection")
    public AttackDetectionResource getAttackDetection() {
        return new AttackDetectionResource(this.session, this.auth, this.adminEvent);
    }

    @Path(value="clients")
    public ClientsResource getClients() {
        return new ClientsResource(this.session, this.auth, this.adminEvent);
    }

    @Deprecated
    @Path(value="client-templates")
    public ClientScopesResource getClientTemplates() {
        return this.getClientScopes();
    }

    @Path(value="client-scopes")
    public ClientScopesResource getClientScopes() {
        return new ClientScopesResource(this.session, this.auth, this.adminEvent);
    }

    @Path(value="localization")
    public RealmLocalizationResource getLocalization() {
        return new RealmLocalizationResource(this.session, this.auth);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Path(value="default-default-client-scopes")
    @Tag(name="Realms Admin")
    @Operation(summary="Get realm default client scopes. Only name and ids are returned.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientScopeRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<ClientScopeRepresentation> getDefaultDefaultClientScopes() {
        return this.getDefaultClientScopes(true);
    }

    private Stream<ClientScopeRepresentation> getDefaultClientScopes(boolean defaultScope) {
        this.auth.clients().requireViewClientScopes();
        return this.realm.getDefaultClientScopesStream(defaultScope).map(clientScope -> {
            ClientScopeRepresentation rep = new ClientScopeRepresentation();
            rep.setId(clientScope.getId());
            rep.setName(clientScope.getName());
            rep.setProtocol(clientScope.getProtocol());
            return rep;
        });
    }

    @PUT
    @NoCache
    @Path(value="default-default-client-scopes/{clientScopeId}")
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public void addDefaultDefaultClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.addDefaultClientScope(clientScopeId, true);
    }

    private void addDefaultClientScope(String clientScopeId, boolean defaultScope) {
        this.auth.clients().requireManageClientScopes();
        ClientScopeModel clientScope = this.realm.getClientScopeById(clientScopeId);
        if (clientScope == null) {
            throw new NotFoundException("Client scope not found");
        }
        this.realm.addDefaultClientScope(clientScope, defaultScope);
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.CLIENT_SCOPE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @DELETE
    @NoCache
    @Path(value="default-default-client-scopes/{clientScopeId}")
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public void removeDefaultDefaultClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.auth.clients().requireManageClientScopes();
        ClientScopeModel clientScope = this.realm.getClientScopeById(clientScopeId);
        if (clientScope == null) {
            throw new NotFoundException("Client scope not found");
        }
        this.realm.removeDefaultClientScope(clientScope);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.CLIENT_SCOPE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Path(value="default-optional-client-scopes")
    @Tag(name="Realms Admin")
    @Operation(summary="Get realm optional client scopes. Only name and ids are returned.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientScopeRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<ClientScopeRepresentation> getDefaultOptionalClientScopes() {
        return this.getDefaultClientScopes(false);
    }

    @PUT
    @NoCache
    @Path(value="default-optional-client-scopes/{clientScopeId}")
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public void addDefaultOptionalClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.addDefaultClientScope(clientScopeId, false);
    }

    @DELETE
    @NoCache
    @Path(value="default-optional-client-scopes/{clientScopeId}")
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public void removeDefaultOptionalClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.removeDefaultDefaultClientScope(clientScopeId);
    }

    @Path(value="clients-initial-access")
    public ClientInitialAccessResource getClientInitialAccess() {
        return new ClientInitialAccessResource(this.session, this.auth, this.adminEvent);
    }

    @Path(value="client-registration-policy")
    public ClientRegistrationPolicyResource getClientRegistrationPolicy() {
        return new ClientRegistrationPolicyResource(this.session, this.auth, this.adminEvent);
    }

    @Path(value="components")
    public ComponentResource getComponents() {
        return new ComponentResource(this.session, this.auth, this.adminEvent);
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.session, (UriInfo)this.session.getContext().getUri(), this.realm, this.auth, (RoleContainerModel)this.realm, this.adminEvent);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Get the top-level representation of the realm It will not include nested information like User and Client representations.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RealmRepresentation.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public RealmRepresentation getRealm() {
        if (this.auth.realm().canViewRealm()) {
            return ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (boolean)false);
        }
        this.auth.realm().requireViewRealmNameList();
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm(this.realm.getName());
        rep.setDefaultLocale(this.realm.getDefaultLocale());
        rep.setDisplayName(this.realm.getDisplayName());
        rep.setDisplayNameHtml(this.realm.getDisplayNameHtml());
        rep.setSupportedLocales(this.realm.getSupportedLocalesStream().collect(Collectors.toSet()));
        rep.setBruteForceProtected(Boolean.valueOf(this.realm.isBruteForceProtected()));
        if (this.auth.users().canView()) {
            rep.setRegistrationEmailAsUsername(Boolean.valueOf(this.realm.isRegistrationEmailAsUsername()));
        }
        return rep;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Update the top-level information of the realm Any user, roles or client information in the representation will be ignored.", description="This will only update top-level attributes of the realm.")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found"), @APIResponse(responseCode="409", description="Conflict"), @APIResponse(responseCode="500", description="Internal Server Error")})
    public Response updateRealm(RealmRepresentation rep) {
        this.auth.realm().requireManageRealm();
        logger.debugf("updating realm: %s", (Object)this.realm.getName());
        if (Config.getAdminRealm().equals(this.realm.getName()) && rep.getRealm() != null && !rep.getRealm().equals(Config.getAdminRealm())) {
            throw ErrorResponse.error("Can't rename master realm", Response.Status.BAD_REQUEST);
        }
        try {
            ReservedCharValidator.validate((String)rep.getRealm());
            ReservedCharValidator.validateLocales((Iterable)rep.getSupportedLocales());
            ReservedCharValidator.validateSecurityHeaders((Map)rep.getBrowserSecurityHeaders());
        }
        catch (ReservedCharValidator.ReservedCharException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        try {
            SMTPUtil.checkSMTPConfiguration(this.session, rep.getSmtpServer());
        }
        catch (EmailException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        try {
            if (!"GENERATE".equals(rep.getPublicKey()) && rep.getPrivateKey() != null && rep.getPublicKey() != null) {
                try {
                    KeyPairVerifier.verify((String)rep.getPrivateKey(), (String)rep.getPublicKey());
                }
                catch (VerificationException e) {
                    throw ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
                }
            }
            if (!"GENERATE".equals(rep.getPublicKey()) && rep.getCertificate() != null) {
                try {
                    X509Certificate cert = PemUtils.decodeCertificate((String)rep.getCertificate());
                    if (cert == null) {
                        throw ErrorResponse.error("Failed to decode certificate", Response.Status.BAD_REQUEST);
                    }
                }
                catch (Exception e) {
                    throw ErrorResponse.error("Failed to decode certificate", Response.Status.BAD_REQUEST);
                }
            }
            if (rep.getAccessCodeLifespanLogin() != null && rep.getAccessCodeLifespanUserAction() != null && (rep.getAccessCodeLifespanLogin() < 1 || rep.getAccessCodeLifespanUserAction() < 1)) {
                throw ErrorResponse.error("AccessCodeLifespanLogin or AccessCodeLifespanUserAction cannot be 0", Response.Status.BAD_REQUEST);
            }
            RepresentationToModel.updateRealm((RealmRepresentation)rep, (RealmModel)this.realm, (KeycloakSession)this.session);
            StoreSyncEvent.fire((KeycloakSession)this.session, (RealmModel)this.realm, (boolean)false);
            this.session.getContext().getUri();
            this.adminEvent.operation(OperationType.UPDATE).representation(rep).success();
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Realm with same name exists");
        }
        catch (ModelIllegalStateException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ModelException e) {
            throw ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (ErrorResponseException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ErrorResponse.error("Failed to update realm", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Tag(name="Realms Admin")
    @Operation(summary="Delete the realm")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public void deleteRealm() {
        this.auth.realm().requireManageRealm();
        if (Config.getAdminRealm().equals(this.realm.getName())) {
            throw ErrorResponse.error("Can't remove master realm", Response.Status.BAD_REQUEST);
        }
        if (!new RealmManager(this.session).removeRealm(this.realm)) {
            throw new NotFoundException("Realm doesn't exist");
        }
        AdminEventBuilder deleteAdminEvent = new AdminEventBuilder(this.auth.adminAuth().getRealm(), this.auth.adminAuth(), this.session, this.connection);
        deleteAdminEvent.operation(OperationType.DELETE).resource(ResourceType.REALM).realm(this.auth.adminAuth().getRealm()).resourcePath(this.realm.getName()).success();
    }

    @Path(value="users")
    public UsersResource users() {
        return new UsersResource(this.session, this.auth, this.adminEvent);
    }

    @NoCache
    @GET
    @Produces(value={"application/json"})
    @Path(value="users-management-permissions")
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ManagementPermissionReference.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public ManagementPermissionReference getUserMgmtPermissions() {
        ProfileHelper.requireFeature(Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ);
        this.auth.realm().requireViewRealm();
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (permissions.users().isPermissionsEnabled()) {
            return this.toUsersMgmtRef(permissions);
        }
        return new ManagementPermissionReference();
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    @Path(value="users-management-permissions")
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ManagementPermissionReference.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public ManagementPermissionReference setUsersManagementPermissionsEnabled(ManagementPermissionReference ref) {
        ProfileHelper.requireFeature(Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ);
        this.auth.realm().requireManageRealm();
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        permissions.users().setPermissionsEnabled(ref.isEnabled());
        if (ref.isEnabled()) {
            return this.toUsersMgmtRef(permissions);
        }
        return new ManagementPermissionReference();
    }

    private ManagementPermissionReference toUsersMgmtRef(AdminPermissionManagement permissions) {
        ManagementPermissionReference ref = new ManagementPermissionReference();
        ref.setEnabled(true);
        ref.setResource(permissions.users().resource().getId());
        Map<String, String> scopes = permissions.users().getPermissions();
        ref.setScopePermissions(scopes);
        return ref;
    }

    @Path(value="organizations")
    public OrganizationsResource organizations() {
        return new OrganizationsResource(this.session, this.auth, this.adminEvent);
    }

    @Path(value="{extension}")
    public Object extension(@PathParam(value="extension") String extension) {
        Object resource;
        AdminRealmResourceProvider provider = (AdminRealmResourceProvider)this.session.getProvider(AdminRealmResourceProvider.class, extension);
        if (provider != null && (resource = provider.getResource(this.session, this.realm, this.auth, this.adminEvent)) != null) {
            return resource;
        }
        throw new NotFoundException();
    }

    @Path(value="authentication")
    public AuthenticationManagementResource flows() {
        return new AuthenticationManagementResource(this.session, this.auth, this.adminEvent);
    }

    @Path(value="roles-by-id")
    public RoleByIdResource rolesById() {
        return new RoleByIdResource(this.session, this.auth, this.adminEvent);
    }

    @Path(value="push-revocation")
    @Produces(value={"application/json"})
    @POST
    @Tag(name="Realms Admin")
    @Operation(summary="Push the realm's revocation policy to any client that has an admin url associated with it.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GlobalRequestResult.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public GlobalRequestResult pushRevocation() {
        this.auth.realm().requireManageRealm();
        GlobalRequestResult result = new ResourceAdminManager(this.session).pushRealmRevocationPolicy(this.realm);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(result).success();
        return result;
    }

    @Path(value="logout-all")
    @POST
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Removes all user sessions.", description="Any client that has an admin url will also be told to invalidate any sessions they have.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GlobalRequestResult.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public GlobalRequestResult logoutAll() {
        this.auth.users().requireManage();
        this.session.sessions().removeUserSessions(this.realm);
        GlobalRequestResult result = new ResourceAdminManager(this.session).logoutAll(this.realm);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(result).success();
        return result;
    }

    @Path(value="sessions/{session}")
    @DELETE
    @Tag(name="Realms Admin")
    @Operation(summary="Remove a specific user session.", description="Any client that has an admin url will also be told to invalidate this particular session.")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public void deleteSession(@PathParam(value="session") String sessionId, @DefaultValue(value="false") @QueryParam(value="isOffline") boolean offline) {
        UserSessionModel userSession;
        this.auth.users().requireManage();
        UserSessionModel userSessionModel = userSession = offline ? this.session.sessions().getOfflineUserSession(this.realm, sessionId) : this.session.sessions().getUserSession(this.realm, sessionId);
        if (userSession == null) {
            throw new NotFoundException("Sesssion not found");
        }
        AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.connection, this.headers, true);
        HashMap<String, Boolean> eventRep = new HashMap<String, Boolean>();
        eventRep.put("offline", offline);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.USER_SESSION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(eventRep).success();
    }

    @Path(value="client-session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Get client session stats Returns a JSON map.", description="The key is the client id, the value is the number of sessions that currently are active with that client. Only clients that actually have a session associated with them will be in this map.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK"), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<Map<String, String>> getClientSessionStats() {
        ClientModel client;
        Map<String, String> map;
        this.auth.realm().requireViewRealm();
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
        Map activeCount = this.session.sessions().getActiveClientSessionStats(this.realm, false);
        for (Map.Entry entry : activeCount.entrySet()) {
            map = new HashMap<String, String>();
            client = this.realm.getClientById((String)entry.getKey());
            if (client == null) continue;
            map.put("id", client.getId());
            map.put("clientId", client.getClientId());
            map.put("active", ((Long)entry.getValue()).toString());
            map.put("offline", "0");
            data.put(client.getId(), map);
        }
        Map offlineCount = this.session.sessions().getActiveClientSessionStats(this.realm, true);
        for (Map.Entry entry : offlineCount.entrySet()) {
            map = (Map)data.get(entry.getKey());
            if (map == null) {
                map = new HashMap();
                client = this.realm.getClientById((String)entry.getKey());
                if (client == null) continue;
                map.put("id", client.getId());
                map.put("clientId", client.getClientId());
                map.put("active", "0");
                data.put(client.getId(), map);
            }
            map.put("offline", ((Long)entry.getValue()).toString());
        }
        return data.values().stream();
    }

    @GET
    @NoCache
    @Path(value="events/config")
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Get the events provider configuration Returns JSON object with events provider configuration")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RealmEventsConfigRepresentation.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public RealmEventsConfigRepresentation getRealmEventsConfig() {
        this.auth.realm().requireViewEvents();
        RealmEventsConfigRepresentation config = ModelToRepresentation.toEventsConfigReprensetation((RealmModel)this.realm);
        if (config.getEnabledEventTypes() == null || config.getEnabledEventTypes().isEmpty()) {
            List eventTypes = Arrays.stream(EventType.values()).filter(EventType::isSaveByDefault).map(Enum::name).collect(Collectors.toList());
            config.setEnabledEventTypes(eventTypes);
        }
        return config;
    }

    @PUT
    @Path(value="events/config")
    @Consumes(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(description="Update the events provider Change the events provider and/or its configuration")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden")})
    public void updateRealmEventsConfig(RealmEventsConfigRepresentation rep) {
        this.auth.realm().requireManageEvents();
        logger.debugf("updating realm events config: %s", (Object)this.realm.getName());
        new RealmManager(this.session).updateRealmEventsConfig(rep, this.realm);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.REALM).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).refreshRealmEventsConfig(this.session).success();
    }

    @Path(value="events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Get events Returns all events, or filters them based on URL query parameters listed here")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EventRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<EventRepresentation> getEvents(@Parameter(description="The types of events to return") @QueryParam(value="type") List<String> types, @Parameter(description="App or oauth client name") @QueryParam(value="client") String client, @Parameter(description="User id") @QueryParam(value="user") String user, @Parameter(description="From (inclusive) date (yyyy-MM-dd) or time in Epoch timestamp millis (number of milliseconds since January 1, 1970, 00:00:00 GMT)") @QueryParam(value="dateFrom") String dateFrom, @Parameter(description="To (inclusive) date (yyyy-MM-dd) or time in Epoch timestamp millis (number of milliseconds since January 1, 1970, 00:00:00 GMT)") @QueryParam(value="dateTo") String dateTo, @Parameter(description="IP Address") @QueryParam(value="ipAddress") String ipAddress, @Parameter(description="Paging offset") @QueryParam(value="first") Integer firstResult, @Parameter(description="Maximum results size (defaults to 100)") @QueryParam(value="max") Integer maxResults, @Parameter(description="The direction to sort events by (asc or desc)") @QueryParam(value="direction") String direction) {
        this.auth.realm().requireViewEvents();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        EventQuery query = eventStore.createQuery().realm(this.realm.getId());
        if (client != null) {
            query.client(client);
        }
        if (types != null && !types.isEmpty()) {
            EventType[] t = new EventType[types.size()];
            for (int i = 0; i < t.length; ++i) {
                t[i] = EventType.valueOf((String)types.get(i));
            }
            query.type(t);
        }
        if (user != null) {
            query.user(user);
        }
        if (dateFrom != null) {
            try {
                query.fromDate(DateUtil.toStartOfDay(dateFrom));
            }
            catch (Throwable t) {
                throw new BadRequestException("Invalid value for 'dateFrom', expected format is yyyy-MM-dd or an Epoch timestamp");
            }
        }
        if (dateTo != null) {
            try {
                query.toDate(DateUtil.toEndOfDay(dateTo));
            }
            catch (Throwable t) {
                throw new BadRequestException("Invalid value for 'dateTo', expected format is yyyy-MM-dd or an Epoch timestamp");
            }
        }
        if (ipAddress != null) {
            query.ipAddress(ipAddress);
        }
        if (direction != null) {
            if ("asc".equals(direction)) {
                query.orderByAscTime();
            } else if ("desc".equals(direction)) {
                query.orderByDescTime();
            } else {
                throw new BadRequestException("Invalid value for sortDirection, expected value is asc or desc");
            }
        }
        if (firstResult != null) {
            query.firstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.maxResults(maxResults.intValue());
        } else {
            query.maxResults(100);
        }
        return query.getResultStream().map(ModelToRepresentation::toRepresentation);
    }

    @Path(value="admin-events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Get admin events Returns all admin events, or filters events based on URL query parameters listed here")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AdminEventRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<AdminEventRepresentation> getEvents(@QueryParam(value="operationTypes") List<String> operationTypes, @QueryParam(value="authRealm") String authRealm, @QueryParam(value="authClient") String authClient, @Parameter(description="user id") @QueryParam(value="authUser") String authUser, @QueryParam(value="authIpAddress") String authIpAddress, @QueryParam(value="resourcePath") String resourcePath, @Parameter(description="From (inclusive) date (yyyy-MM-dd) or time in Epoch timestamp millis (number of milliseconds since January 1, 1970, 00:00:00 GMT)") @QueryParam(value="dateFrom") String dateFrom, @Parameter(description="To (inclusive) date (yyyy-MM-dd) or time in Epoch timestamp millis (number of milliseconds since January 1, 1970, 00:00:00 GMT)") @QueryParam(value="dateTo") String dateTo, @QueryParam(value="first") Integer firstResult, @Parameter(description="Maximum results size (defaults to 100)") @QueryParam(value="max") Integer maxResults, @QueryParam(value="resourceTypes") List<String> resourceTypes, @Parameter(description="The direction to sort events by (asc or desc)") @QueryParam(value="direction") String direction) {
        int i;
        OperationType[] t;
        this.auth.realm().requireViewEvents();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        AdminEventQuery query = eventStore.createAdminQuery().realm(this.realm.getId());
        if (authRealm != null) {
            query.authRealm(authRealm);
        }
        if (authClient != null) {
            query.authClient(authClient);
        }
        if (authUser != null) {
            query.authUser(authUser);
        }
        if (authIpAddress != null) {
            query.authIpAddress(authIpAddress);
        }
        if (resourcePath != null) {
            query.resourcePath(resourcePath);
        }
        if (operationTypes != null && !operationTypes.isEmpty()) {
            t = new OperationType[operationTypes.size()];
            for (i = 0; i < t.length; ++i) {
                t[i] = OperationType.valueOf((String)operationTypes.get(i));
            }
            query.operation(t);
        }
        if (resourceTypes != null && !resourceTypes.isEmpty()) {
            t = new ResourceType[resourceTypes.size()];
            for (i = 0; i < t.length; ++i) {
                t[i] = ResourceType.valueOf((String)resourceTypes.get(i));
            }
            query.resourceType((ResourceType[])t);
        }
        if (dateFrom != null) {
            try {
                query.fromTime(DateUtil.toStartOfDay(dateFrom));
            }
            catch (Throwable t2) {
                throw new BadRequestException("Invalid value for 'dateFrom', expected format is yyyy-MM-dd or an Epoch timestamp");
            }
        }
        if (dateTo != null) {
            try {
                query.toTime(DateUtil.toEndOfDay(dateTo));
            }
            catch (Throwable t3) {
                throw new BadRequestException("Invalid value for 'dateTo', expected format is yyyy-MM-dd or an Epoch timestamp");
            }
        }
        if (direction != null) {
            if ("asc".equals(direction)) {
                query.orderByAscTime();
            } else if ("desc".equals(direction)) {
                query.orderByDescTime();
            } else {
                throw new BadRequestException("Invalid value for sortDirection, expected value is asc or desc");
            }
        }
        if (firstResult != null) {
            query.firstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.maxResults(maxResults.intValue());
        } else {
            query.maxResults(100);
        }
        return query.getResultStream().map(ModelToRepresentation::toRepresentation);
    }

    @Path(value="events")
    @DELETE
    @Tag(name="Realms Admin")
    @Operation(summary="Delete all events")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden")})
    public void clearEvents() {
        this.auth.realm().requireManageEvents();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clear(this.realm);
    }

    @Path(value="admin-events")
    @DELETE
    @Tag(name="Realms Admin")
    @Operation(summary="Delete all admin events")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden")})
    public void clearAdminEvents() {
        this.auth.realm().requireManageEvents();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clearAdmin(this.realm);
    }

    @Path(value="testSMTPConnection")
    @POST
    @NoCache
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Deprecated
    @Tag(name="Realms Admin")
    @Operation(summary="Test SMTP connection with current logged in user")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="500", description="Internal Server Error")})
    public Response testSMTPConnection(@Parameter(description="SMTP server configuration") @FormParam(value="config") String config) throws Exception {
        Map settings = (Map)JsonSerialization.readValue((String)config, (TypeReference)new TypeReference<Map<String, String>>(){});
        return this.testSMTPConnection(settings);
    }

    @Path(value="testSMTPConnection")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="500", description="Internal Server Error")})
    public Response testSMTPConnection(Map<String, String> settings) throws Exception {
        this.auth.realm().requireManageRealm();
        try {
            UserModel user = this.auth.adminAuth().getUser();
            if (user.getEmail() == null) {
                throw ErrorResponse.error("Logged in user does not have an e-mail.", Response.Status.INTERNAL_SERVER_ERROR);
            }
            if ("**********".equals(settings.get("password")) && this.reuseConfiguredAuthenticationForSmtp(settings, EmailAuthenticator.AuthenticatorType.BASIC)) {
                settings.put("password", (String)this.realm.getSmtpConfig().get("password"));
            }
            if ("**********".equals(settings.get("authTokenClientSecret")) && this.reuseConfiguredAuthenticationForSmtp(settings, EmailAuthenticator.AuthenticatorType.TOKEN)) {
                settings.put("authTokenClientSecret", (String)this.realm.getSmtpConfig().get("authTokenClientSecret"));
            }
            ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).sendSmtpTestEmail(settings, user);
        }
        catch (Exception e) {
            logger.errorf((Throwable)e, "Failed to send email \n %s", (Object)e.getCause());
            throw ErrorResponse.error("Failed to send email", Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.noContent().build();
    }

    private boolean reuseConfiguredAuthenticationForSmtp(Map<String, String> settings, EmailAuthenticator.AuthenticatorType type) {
        return Boolean.parseBoolean(settings.get("auth")) && Boolean.parseBoolean((String)this.realm.getSmtpConfig().get("auth")) && Optional.ofNullable(settings.get("authType")).orElse(EmailAuthenticator.AuthenticatorType.BASIC.name()).equalsIgnoreCase(type.name()) && this.realm.getSmtpConfig().getOrDefault("authType", EmailAuthenticator.AuthenticatorType.BASIC.name()).equalsIgnoreCase(type.name()) && Objects.equals(Optional.ofNullable(settings.get("host")).orElse(""), this.realm.getSmtpConfig().getOrDefault("host", "")) && Objects.equals(Optional.ofNullable(settings.get("port")).orElse("25"), this.realm.getSmtpConfig().getOrDefault("port", "25")) && Objects.equals(Optional.ofNullable(settings.get("user")).orElse(""), this.realm.getSmtpConfig().getOrDefault("user", ""));
    }

    @Path(value="identity-provider")
    public IdentityProvidersResource getIdentityProviderResource() {
        return new IdentityProvidersResource(this.realm, this.session, this.auth, this.adminEvent);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Path(value="default-groups")
    @Tag(name="Realms Admin")
    @Operation(summary="Get group hierarchy.  Only name and ids are returned.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GroupRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<GroupRepresentation> getDefaultGroups() {
        this.auth.realm().requireViewRealm();
        return this.realm.getDefaultGroupsStream().map(ModelToRepresentation::groupToBriefRepresentation);
    }

    @PUT
    @NoCache
    @Path(value="default-groups/{groupId}")
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public void addDefaultGroup(@PathParam(value="groupId") String groupId) {
        this.auth.realm().requireManageRealm();
        GroupModel group = this.realm.getGroupById(groupId);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.realm.addDefaultGroup(group);
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.GROUP).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @DELETE
    @NoCache
    @Path(value="default-groups/{groupId}")
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public void removeDefaultGroup(@PathParam(value="groupId") String groupId) {
        this.auth.realm().requireManageRealm();
        GroupModel group = this.realm.getGroupById(groupId);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.realm.removeDefaultGroup(group);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.GROUP).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="groups")
    public GroupsResource getGroups() {
        return new GroupsResource(this.realm, this.session, this.auth, this.adminEvent);
    }

    @GET
    @Path(value="group-by-path/{path: .*}")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GroupRepresentation.class))}), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public GroupRepresentation getGroupByPath(@PathParam(value="path") String path) {
        GroupModel found = KeycloakModelUtils.findGroupByPath((KeycloakSession)this.session, (RealmModel)this.realm, (String)path);
        if (found == null) {
            throw new NotFoundException("Group path does not exist");
        }
        this.auth.groups().requireView(found);
        GroupRepresentation groupRep = ModelToRepresentation.toRepresentation((GroupModel)found, (boolean)true);
        return GroupUtils.populateSubGroupCount(found, groupRep);
    }

    @Path(value="partialImport")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Partial import from a JSON file to an existing realm.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=PartialImportResults.class))}), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="409", description="Conflict")})
    public Response partialImport(InputStream requestBody) {
        this.auth.realm().requireManageRealm();
        try {
            return Response.ok((Object)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), (KeycloakContext)this.session.getContext(), kcSession -> {
                RealmModel realmClone = kcSession.realms().getRealm(this.realm.getId());
                AdminEventBuilder adminEventClone = this.adminEvent.clone(kcSession);
                return RealmAdminResource.getPartialImportResults(requestBody, kcSession, realmClone, adminEventClone);
            }, (String)("Partial import in realm " + this.realm.getName()))).build();
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists(e.getLocalizedMessage());
        }
    }

    private static PartialImportResults getPartialImportResults(InputStream requestBody, KeycloakSession kcSession, RealmModel kcRealm, AdminEventBuilder adminEventClone) {
        ExportImportManager exportProvider = ((DatastoreProvider)kcSession.getProvider(DatastoreProvider.class)).getExportImportManager();
        PartialImportResults results = exportProvider.partialImportRealm(kcRealm, requestBody);
        for (PartialImportResult result : results.getResults()) {
            switch (result.getAction()) {
                case ADDED: {
                    RealmAdminResource.fireCreatedEvent(result, adminEventClone);
                    break;
                }
                case OVERWRITTEN: {
                    RealmAdminResource.fireUpdateEvent(result, adminEventClone);
                }
            }
        }
        return results;
    }

    private static void fireCreatedEvent(PartialImportResult result, AdminEventBuilder adminEvent) {
        adminEvent.operation(OperationType.CREATE).resourcePath(result.getResourceType().getPath(), result.getId()).representation(result.getRepresentation()).success();
    }

    private static void fireUpdateEvent(PartialImportResult result, AdminEventBuilder adminEvent) {
        adminEvent.operation(OperationType.UPDATE).resourcePath(result.getResourceType().getPath(), result.getId()).representation(result.getRepresentation()).success();
    }

    @Path(value="partial-export")
    @Produces(value={"application/json"})
    @POST
    @Tag(name="Realms Admin")
    @Operation(summary="Partial export of existing realm into a JSON file.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RealmRepresentation.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Response partialExport(@QueryParam(value="exportGroupsAndRoles") Boolean exportGroupsAndRoles, @QueryParam(value="exportClients") Boolean exportClients) {
        boolean clientsExported;
        this.auth.realm().requireManageRealm();
        boolean groupsAndRolesExported = exportGroupsAndRoles != null && exportGroupsAndRoles != false;
        boolean bl = clientsExported = exportClients != null && exportClients != false;
        if (groupsAndRolesExported) {
            this.auth.groups().requireList();
        }
        if (clientsExported) {
            this.auth.clients().requireView();
        }
        ExportOptions options = new ExportOptions(false, clientsExported, groupsAndRolesExported, clientsExported, true);
        ExportImportManager exportProvider = ((DatastoreProvider)this.session.getProvider(DatastoreProvider.class)).getExportImportManager();
        final Response.ResponseBuilder response = Response.ok();
        exportProvider.exportRealm(this.realm, options, new ExportAdapter(){

            public void setType(String mediaType) {
                response.type(mediaType);
            }

            public void writeToOutputStream(ExportAdapter.ConsumerOfOutputStream consumer) {
                response.entity(arg_0 -> ((ExportAdapter.ConsumerOfOutputStream)consumer).accept(arg_0));
            }
        });
        return response.build();
    }

    @Path(value="keys")
    public KeyResource keys() {
        return new KeyResource(this.realm, this.session, this.auth);
    }

    @GET
    @Path(value="credential-registrators")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="200", description="OK"), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<String> getCredentialRegistrators() {
        this.auth.realm().requireViewRealm();
        return this.session.getContext().getRealm().getRequiredActionProvidersStream().filter(RequiredActionProviderModel::isEnabled).map(RequiredActionProviderModel::getProviderId).filter(providerId -> this.session.getProvider(RequiredActionProvider.class, providerId) instanceof CredentialRegistrator);
    }

    @Path(value="client-policies/policies")
    public ClientPoliciesResource getClientPoliciesResource() {
        ProfileHelper.requireFeature(Profile.Feature.CLIENT_POLICIES);
        return new ClientPoliciesResource(this.session, this.auth);
    }

    @Path(value="client-policies/profiles")
    public ClientProfilesResource getClientProfilesResource() {
        ProfileHelper.requireFeature(Profile.Feature.CLIENT_POLICIES);
        return new ClientProfilesResource(this.session, this.auth);
    }

    @Path(value="client-types")
    public ClientTypesResource getClientTypesResource() {
        ProfileHelper.requireFeature(Profile.Feature.CLIENT_TYPES);
        return new ClientTypesResource((ClientTypeManager)this.session.getProvider(ClientTypeManager.class), this.realm, this.auth);
    }
}

