/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandNotFoundHandler;
import org.aesh.command.CommandResolver;
import org.aesh.command.CommandResult;
import org.aesh.command.CommandRuntime;
import org.aesh.command.Execution;
import org.aesh.command.Executor;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.activator.OptionActivatorProvider;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.converter.ConverterInvocationProvider;
import org.aesh.command.impl.AeshCommandResolver;
import org.aesh.command.impl.Executions;
import org.aesh.command.impl.activator.AeshOptionActivatorProvider;
import org.aesh.command.impl.completer.CompleterData;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.invocation.AeshInvocationProviders;
import org.aesh.command.impl.parser.AeshCommandLineCompletionParser;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationBuilder;
import org.aesh.command.invocation.CommandInvocationConfiguration;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.operator.OperatorType;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.command.validator.ValidatorInvocationProvider;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.parser.LineParser;
import org.aesh.parser.ParsedLine;
import org.aesh.parser.ParserStatus;
import org.aesh.readline.AeshContext;
import org.aesh.readline.completion.CompleteOperation;

public class AeshCommandRuntime<CI extends CommandInvocation>
implements CommandRuntime<CI>,
CommandRegistry.CommandRegistrationListener {
    private final CommandRegistry<CI> registry;
    private final CommandInvocationProvider<CI> commandInvocationProvider;
    private final InvocationProviders invocationProviders;
    private static final Logger LOGGER = Logger.getLogger(AeshCommandRuntime.class.getName());
    private final CommandNotFoundHandler commandNotFoundHandler;
    private final CommandResolver<CI> commandResolver;
    private final AeshContext ctx;
    private final CommandInvocationBuilder<CI> commandInvocationBuilder;
    private final boolean parseBrackets;
    private final EnumSet<OperatorType> operators;

    public AeshCommandRuntime(AeshContext ctx, CommandRegistry<CI> registry, CommandInvocationProvider<CI> commandInvocationProvider, CommandNotFoundHandler commandNotFoundHandler, CompleterInvocationProvider completerInvocationProvider, ConverterInvocationProvider converterInvocationProvider, ValidatorInvocationProvider validatorInvocationProvider, OptionActivatorProvider optionActivatorProvider, CommandActivatorProvider commandActivatorProvider, CommandInvocationBuilder<CI> commandInvocationBuilder, boolean parseBrackets, EnumSet<OperatorType> operators) {
        this.ctx = ctx;
        this.registry = registry;
        this.commandResolver = new AeshCommandResolver<CI>(registry);
        this.commandInvocationProvider = commandInvocationProvider;
        this.commandNotFoundHandler = commandNotFoundHandler;
        this.commandInvocationBuilder = commandInvocationBuilder;
        this.invocationProviders = new AeshInvocationProviders(converterInvocationProvider, completerInvocationProvider, validatorInvocationProvider, optionActivatorProvider, commandActivatorProvider);
        this.processAfterInit();
        registry.addRegistrationListener(this);
        this.parseBrackets = parseBrackets;
        this.operators = operators;
    }

    @Override
    public CommandRegistry<CI> getCommandRegistry() {
        return this.registry;
    }

    @Override
    public AeshContext getAeshContext() {
        return this.ctx;
    }

    @Override
    public CommandInvocationBuilder<CI> commandInvocationBuilder() {
        return this.commandInvocationBuilder;
    }

    @Override
    public InvocationProviders invocationProviders() {
        return this.invocationProviders;
    }

    @Override
    public CommandResult executeCommand(String line) throws CommandNotFoundException, CommandLineParserException, CommandValidatorException, CommandException, InterruptedException, IOException {
        Execution<CI> exec;
        Executor<CI> executor;
        try {
            executor = this.buildExecutor(line);
        }
        catch (CommandLineParserException e) {
            throw e;
        }
        catch (CommandNotFoundException cmd) {
            if (this.commandNotFoundHandler != null) {
                this.commandNotFoundHandler.handleCommandNotFound(line, this.commandInvocationBuilder.build(this, null, null).getShell());
            }
            throw cmd;
        }
        CommandResult result = null;
        while ((exec = executor.getNextExecution()) != null) {
            try {
                result = exec.execute();
            }
            catch (CommandException cmd) {
                if (exec.getResultHandler() != null) {
                    exec.getResultHandler().onExecutionFailure(CommandResult.FAILURE, cmd);
                }
                throw cmd;
            }
            catch (CommandLineParserException | CommandValidatorException e) {
                if (exec.getResultHandler() != null) {
                    exec.getResultHandler().onValidationFailure(CommandResult.FAILURE, e);
                }
                throw e;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                if (exec.getResultHandler() != null) {
                    exec.getResultHandler().onValidationFailure(CommandResult.FAILURE, ex);
                }
                throw ex;
            }
            catch (Exception e) {
                if (exec.getResultHandler() != null) {
                    exec.getResultHandler().onValidationFailure(CommandResult.FAILURE, e);
                }
                throw new RuntimeException(e);
            }
        }
        if (result != null) {
            return result;
        }
        return CommandResult.FAILURE;
    }

    @Override
    public CommandResult executeCommand(String ... lines) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, CommandException, InterruptedException, IOException {
        if (lines == null || lines.length == 0) {
            throw new CommandException("No input lines");
        }
        CommandResult result = null;
        for (String line : lines) {
            result = this.executeCommand(line);
            if (result != CommandResult.FAILURE) continue;
            return result;
        }
        return result;
    }

    private void processAfterInit() {
        try {
            for (String commandName : this.registry.getAllCommandNames()) {
                this.updateCommand(commandName);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Exception while iterating commands.", e);
        }
    }

    private void updateCommand(String commandName) throws CommandNotFoundException {
        ProcessedCommand<Command<CI>, CI> cmd = this.registry.getCommand(commandName, "").getParser().getProcessedCommand();
        List<CommandLineParser<CI>> childParsers = this.registry.getChildCommandParsers(commandName);
        if (!(this.invocationProviders.getOptionActivatorProvider() instanceof AeshOptionActivatorProvider)) {
            cmd.updateInvocationProviders(this.invocationProviders);
            for (CommandLineParser<CI> child : childParsers) {
                child.getProcessedCommand().updateInvocationProviders(this.invocationProviders);
            }
        }
    }

    @Override
    public Executor<CI> buildExecutor(String line) throws CommandNotFoundException, CommandLineParserException, IOException {
        LOGGER.fine("Command: " + line);
        List<ParsedLine> lines = new LineParser().parseLine(line, -1, this.parseBrackets, this.operators);
        List executions = Executions.buildExecution(lines, this);
        return new Executor(executions);
    }

    CI buildCommandInvocation(CommandInvocationConfiguration config, CommandContainer<CI> commandContainer) {
        return this.commandInvocationProvider.enhanceCommandInvocation((CommandInvocation)this.commandInvocationBuilder.build(this, config, commandContainer));
    }

    CommandContainer<CI> findCommandContainer(ParsedLine aeshLine) throws CommandNotFoundException {
        if (aeshLine.words().isEmpty()) {
            return null;
        }
        String name = aeshLine.firstWord().word();
        CommandContainer<CI> container = this.commandResolver.resolveCommand(name, aeshLine.line());
        if (container == null) {
            throw new CommandNotFoundException("No command handler for '" + name + "'.", name);
        }
        container.addLine(aeshLine);
        return container;
    }

    void populateAskedOption(ProcessedOption option) {
        try {
            option.injectValueIntoField(option.parent().getCommand(), this.invocationProviders, this.getAeshContext(), false);
        }
        catch (OptionValidatorException e) {
            LOGGER.log(Level.WARNING, "Trying to inject value: " + option.getValue() + ", into option: " + option.name() + " failed", e);
        }
    }

    @Override
    public void registrationAction(String commandName, CommandRegistry.REGISTRATION_ACTION action) {
        if (action == CommandRegistry.REGISTRATION_ACTION.ADDED) {
            try {
                this.updateCommand(commandName);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, "Exception while iterating commands.", e);
            }
        }
    }

    @Override
    public void complete(AeshCompleteOperation completeOperation) {
        if (this.operators.isEmpty()) {
            this.simpleComplete(completeOperation);
        } else {
            this.completeWithOperators(completeOperation);
        }
    }

    private void completeWithOperators(AeshCompleteOperation completeOperation) {
        List<ParsedLine> lines = new LineParser().input(completeOperation.getBuffer()).cursor(completeOperation.getCursor()).parseBrackets(true).operators(this.operators).parseWithOperators();
        if (!lines.isEmpty()) {
            for (int i = 0; i < lines.size(); ++i) {
                if (lines.get(i).cursor() <= -1) continue;
                if (i == 0) {
                    this.doSimpleComplete(completeOperation, lines.get(i));
                    return;
                }
                if (OperatorType.isAppendOrRedirectInOrOut(lines.get(i - 1).operator())) {
                    FileOptionCompleter completer = new FileOptionCompleter();
                    CompleterData invocation = new CompleterData(completeOperation.getContext(), lines.get(i).selectedWord().word(), null);
                    completer.complete(invocation);
                    completeOperation.addCompletionCandidatesTerminalString(invocation.getCompleterValues());
                    AeshCommandLineCompletionParser.verifyCompleteValue(completeOperation, invocation, lines.get(i).selectedWord().word(), lines.get(i).selectedWord().status(), null);
                    return;
                }
                this.doSimpleComplete(completeOperation, lines.get(i));
                return;
            }
            this.doSimpleComplete(completeOperation, lines.get(lines.size() - 1));
        }
        this.simpleComplete(completeOperation);
    }

    private void simpleComplete(AeshCompleteOperation completeOperation) {
        ParsedLine parsedLine = new LineParser().input(completeOperation.getBuffer()).cursor(completeOperation.getCursor()).parseBrackets(true).parse();
        this.doSimpleComplete(completeOperation, parsedLine);
    }

    private void doSimpleComplete(AeshCompleteOperation completeOperation, ParsedLine parsedLine) {
        if ((parsedLine.selectedIndex() == 0 || parsedLine.words().size() == 0) && ParserStatus.okForCompletion(parsedLine.status())) {
            this.commandResolver.getRegistry().completeCommandName((CompleteOperation)completeOperation, parsedLine);
        }
        if (completeOperation.getCompletionCandidates().size() < 1) {
            try (CommandContainer<CI> commandContainer2 = this.commandResolver.resolveCommand(parsedLine);){
                commandContainer2.getParser().complete(completeOperation, parsedLine, this.invocationProviders);
            }
            catch (CommandNotFoundException commandContainer2) {
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Runtime exception when completing: " + (Object)((Object)completeOperation), ex);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.registry.removeRegistrationListener(this);
        super.finalize();
    }
}

