/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.protocol;

import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.EncryptedElementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLRequestAbstractParser;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;

public class SAMLSloRequestParser
extends SAMLRequestAbstractParser<LogoutRequestType> {
    private static final SAMLSloRequestParser INSTANCE = new SAMLSloRequestParser();

    private SAMLSloRequestParser() {
        super(SAMLProtocolQNames.LOGOUT_REQUEST);
    }

    public static SAMLSloRequestParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected LogoutRequestType instantiateElement(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        SAMLParserUtil.validateAttributeValue(startElement, SAMLProtocolQNames.ATTR_VERSION, "2.0");
        String id = StaxParserUtil.getRequiredAttributeValue(startElement, SAMLProtocolQNames.ATTR_ID);
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getRequiredAttributeValue(startElement, SAMLProtocolQNames.ATTR_ISSUE_INSTANT));
        LogoutRequestType logoutRequest = new LogoutRequestType(id, issueInstant);
        super.parseBaseAttributes(startElement, logoutRequest);
        logoutRequest.setReason(StaxParserUtil.getAttributeValue(startElement, SAMLProtocolQNames.ATTR_REASON));
        logoutRequest.setNotOnOrAfter(StaxParserUtil.getXmlTimeAttributeValue(startElement, SAMLProtocolQNames.ATTR_NOT_ON_OR_AFTER));
        return logoutRequest;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, LogoutRequestType target, SAMLProtocolQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case ISSUER: 
            case SIGNATURE: 
            case EXTENSIONS: {
                this.parseCommonElements(element, elementDetail, xmlEventReader, (RequestAbstractType)target);
                break;
            }
            case NAMEID: {
                NameIDType nameID = SAMLParserUtil.parseNameIDType(xmlEventReader);
                target.setNameID(nameID);
                break;
            }
            case ENCRYPTED_ID: {
                Element domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                target.setEncryptedID(new EncryptedElementType(domElement));
                break;
            }
            case SESSION_INDEX: {
                StaxParserUtil.getNextStartElement(xmlEventReader);
                target.addSessionIndex(StaxParserUtil.getElementText(xmlEventReader));
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

