/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.common.util;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.PropertyPermission;

public class SecurityActions {
    private static String extractPackageNameFromClassName(String fullyQualifiedName) {
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return fullyQualifiedName.substring(0, lastDot);
    }

    public static Class<?> loadClass(final Class<?> theClass, final String fullQualifiedName) {
        SecurityManager sm = System.getSecurityManager();
        if (fullQualifiedName == null) {
            return null;
        }
        if (sm != null) {
            sm.checkPackageDefinition(SecurityActions.extractPackageNameFromClassName(fullQualifiedName));
            return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    ClassLoader classLoader = theClass.getClassLoader();
                    Class<?> clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
                    if (clazz == null) {
                        classLoader = Thread.currentThread().getContextClassLoader();
                        clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
                    }
                    return clazz;
                }
            });
        }
        ClassLoader classLoader = theClass.getClassLoader();
        Class<?> clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
        if (clazz == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
        }
        return clazz;
    }

    public static Class<?> loadClass(final ClassLoader classLoader, final String fullQualifiedName) {
        SecurityManager sm = System.getSecurityManager();
        if (fullQualifiedName == null) {
            return null;
        }
        if (sm != null) {
            sm.checkPackageDefinition(SecurityActions.extractPackageNameFromClassName(fullQualifiedName));
            return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        return classLoader.loadClass(fullQualifiedName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return null;
                    }
                }
            });
        }
        try {
            return classLoader.loadClass(fullQualifiedName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static URL loadResource(final Class<?> clazz, final String resourceName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    ClassLoader clazzLoader = clazz.getClassLoader();
                    URL url = clazzLoader.getResource(resourceName);
                    if (url == null) {
                        clazzLoader = Thread.currentThread().getContextClassLoader();
                        url = clazzLoader.getResource(resourceName);
                    }
                    return url;
                }
            });
        }
        ClassLoader clazzLoader = clazz.getClassLoader();
        URL url = clazzLoader.getResource(resourceName);
        if (url == null) {
            clazzLoader = Thread.currentThread().getContextClassLoader();
            url = clazzLoader.getResource(resourceName);
        }
        return url;
    }

    public static void setSystemProperty(final String key, final String value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty(key, value);
                    return null;
                }
            });
        } else {
            System.setProperty(key, value);
        }
    }

    public static String getSystemProperty(final String key, final String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "read"));
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key, defaultValue);
                }
            });
        }
        return System.getProperty(key, defaultValue);
    }

    public static ClassLoader getTCCL() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new RuntimePermission("getClassLoader"));
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static void setTCCL(final ClassLoader paramCl) {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new RuntimePermission("setContextClassLoader"));
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread.currentThread().setContextClassLoader(paramCl);
                    return null;
                }
            });
        } else {
            Thread.currentThread().setContextClassLoader(paramCl);
        }
    }
}

