/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.devtools.project.extensions.ExtensionInstallPlan;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class BuildFile
implements ExtensionManager {
    private final Path projectDirPath;
    private final ExtensionCatalog catalog;

    public BuildFile(Path projectDirPath, ExtensionCatalog catalog) {
        this.projectDirPath = Objects.requireNonNull(projectDirPath, "projectPath is required");
        this.catalog = Objects.requireNonNull(catalog, "catalog is required");
    }

    @Override
    public final ExtensionManager.InstallResult install(Collection<ArtifactCoords> coords) throws IOException {
        ExtensionInstallPlan.Builder builder = ExtensionInstallPlan.builder();
        for (ArtifactCoords coord : coords) {
            if ("pom".equals(coord.getType())) {
                builder.addPlatform(coord);
                continue;
            }
            if (coord.getVersion() == null) {
                builder.addManagedExtension(coord);
                continue;
            }
            builder.addIndependentExtension(coord);
        }
        return this.install(builder.build());
    }

    @Override
    public ExtensionManager.InstallResult install(ExtensionInstallPlan plan) throws IOException {
        this.refreshData();
        ArrayList<ArtifactCoords> installedManagedExtensions = new ArrayList<ArtifactCoords>();
        ArrayList<ArtifactCoords> installedIndependentExtensions = new ArrayList<ArtifactCoords>();
        ArrayList<ArtifactCoords> installedPlatforms = new ArrayList<ArtifactCoords>();
        Set<ArtifactKey> alreadyInstalled = this.alreadyInstalled(plan.toCollection());
        for (ArtifactCoords platform : this.withoutAlreadyInstalled(alreadyInstalled, plan.getPlatforms())) {
            if (!this.importBom(platform)) continue;
            installedPlatforms.add(platform);
        }
        for (ArtifactCoords managedExtension : this.withoutAlreadyInstalled(alreadyInstalled, plan.getManagedExtensions())) {
            if (!this.addDependency(managedExtension, true)) continue;
            installedManagedExtensions.add(managedExtension);
        }
        for (ArtifactCoords independentExtension : this.withoutAlreadyInstalled(alreadyInstalled, plan.getIndependentExtensions())) {
            if (!this.addDependency(independentExtension, false)) continue;
            installedIndependentExtensions.add(independentExtension);
        }
        this.writeToDisk();
        return new ExtensionManager.InstallResult(installedPlatforms, installedManagedExtensions, installedIndependentExtensions, alreadyInstalled);
    }

    @Override
    public final Collection<ArtifactCoords> getInstalled() throws IOException {
        if (this.catalog == null) {
            return Collections.emptyList();
        }
        this.refreshData();
        Set catalogKeys = this.catalog.getExtensions().stream().map(e -> e.getArtifact().getKey()).collect(Collectors.toSet());
        return this.getDependencies().stream().filter(d -> catalogKeys.contains(d.getKey())).collect(Collectors.toList());
    }

    @Override
    public final ExtensionManager.UninstallResult uninstall(Collection<ArtifactKey> keys) throws IOException {
        this.refreshData();
        Set<ArtifactKey> existingKeys = this.getDependenciesKeys();
        List<ArtifactKey> uninstalled = keys.stream().distinct().filter(existingKeys::contains).filter(k -> {
            try {
                this.removeDependency((ArtifactKey)k);
                return true;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }).collect(Collectors.toList());
        this.writeToDisk();
        return new ExtensionManager.UninstallResult(uninstalled);
    }

    private Set<ArtifactKey> alreadyInstalled(Collection<ArtifactCoords> extensions) throws IOException {
        Set<ArtifactKey> existingKeys = this.getDependenciesKeys();
        return extensions.stream().distinct().filter(a -> existingKeys.contains(a.getKey())).map(ArtifactCoords::getKey).collect(Collectors.toSet());
    }

    private Collection<ArtifactCoords> withoutAlreadyInstalled(Set<ArtifactKey> existingKeys, Collection<ArtifactCoords> extensions) {
        return extensions.stream().distinct().filter(a -> !existingKeys.contains(a.getKey())).collect(Collectors.toList());
    }

    protected abstract boolean importBom(ArtifactCoords var1);

    protected abstract boolean addDependency(ArtifactCoords var1, boolean var2);

    protected abstract void removeDependency(ArtifactKey var1) throws IOException;

    protected abstract List<ArtifactCoords> getDependencies() throws IOException;

    protected abstract void writeToDisk() throws IOException;

    protected abstract String getProperty(String var1) throws IOException;

    protected abstract void refreshData();

    protected Path getProjectDirPath() {
        return this.projectDirPath;
    }

    protected boolean hasProjectFile(String fileName) throws IOException {
        Path filePath = this.projectDirPath.resolve(fileName);
        return Files.exists(filePath, new LinkOption[0]);
    }

    protected byte[] readProjectFile(String fileName) throws IOException {
        Path filePath = this.projectDirPath.resolve(fileName);
        return Files.readAllBytes(filePath);
    }

    protected void writeToProjectFile(String fileName, byte[] content) throws IOException {
        Files.write(this.projectDirPath.resolve(fileName), content, new OpenOption[0]);
    }

    protected void writeToProjectFile(String fileName, String content) throws IOException {
        Files.writeString(this.projectDirPath.resolve(fileName), (CharSequence)content, new OpenOption[0]);
    }

    private Set<ArtifactKey> getDependenciesKeys() throws IOException {
        return this.getDependencies().stream().map(ArtifactCoords::getKey).collect(Collectors.toSet());
    }

    public static boolean isDefinedInRegistry(Collection<Extension> registry, ArtifactKey key) {
        return Extensions.findInList(registry, key).isPresent();
    }
}

