/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.Types;
import io.quarkus.arc.processor.bcextensions.SyntheticBeanBuilderImpl;
import io.quarkus.arc.processor.bcextensions.SyntheticObserverBuilderImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticBeanBuilder;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticObserverBuilder;
import java.util.List;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

class SyntheticComponentsImpl
implements SyntheticComponents {
    final List<SyntheticBeanBuilderImpl<?>> syntheticBeans;
    final List<SyntheticObserverBuilderImpl<?>> syntheticObservers;
    final DotName extensionClass;

    SyntheticComponentsImpl(List<SyntheticBeanBuilderImpl<?>> syntheticBeans, List<SyntheticObserverBuilderImpl<?>> syntheticObservers, DotName extensionClass) {
        this.syntheticBeans = syntheticBeans;
        this.syntheticObservers = syntheticObservers;
        this.extensionClass = extensionClass;
    }

    public <T> SyntheticBeanBuilder<T> addBean(Class<T> implementationClass) {
        SyntheticBeanBuilderImpl builder = new SyntheticBeanBuilderImpl(implementationClass);
        this.syntheticBeans.add(builder);
        return builder;
    }

    public <T> SyntheticObserverBuilder<T> addObserver(Class<T> eventType) {
        Type jandexType = Types.jandexType(eventType);
        SyntheticObserverBuilderImpl builder = new SyntheticObserverBuilderImpl(this.extensionClass, jandexType);
        this.syntheticObservers.add(builder);
        return builder;
    }

    public <T> SyntheticObserverBuilder<T> addObserver(jakarta.enterprise.lang.model.types.Type eventType) {
        Object jandexType = ((TypeImpl)eventType).jandexType;
        SyntheticObserverBuilderImpl builder = new SyntheticObserverBuilderImpl(this.extensionClass, (Type)jandexType);
        this.syntheticObservers.add(builder);
        return builder;
    }
}

