/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.ClassConfigImpl;
import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.inject.build.compatible.spi.ClassConfig;
import jakarta.enterprise.inject.build.compatible.spi.MetaAnnotations;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MutableAnnotationOverlay;

class MetaAnnotationsImpl
implements MetaAnnotations {
    private final IndexView applicationIndex;
    private final MutableAnnotationOverlay annotationOverlay;
    private final Map<DotName, ClassConfig> qualifiers;
    private final Map<DotName, ClassConfig> interceptorBindings;
    private final Map<DotName, ClassConfig> stereotypes;
    private final List<ContextData> contexts;

    MetaAnnotationsImpl(IndexView applicationIndex, MutableAnnotationOverlay annotationOverlay, Map<DotName, ClassConfig> qualifiers, Map<DotName, ClassConfig> interceptorBindings, Map<DotName, ClassConfig> stereotypes, List<ContextData> contexts) {
        this.applicationIndex = applicationIndex;
        this.annotationOverlay = annotationOverlay;
        this.qualifiers = qualifiers;
        this.interceptorBindings = interceptorBindings;
        this.stereotypes = stereotypes;
        this.contexts = contexts;
    }

    public ClassConfig addQualifier(Class<? extends Annotation> annotation) {
        return this.addMetaAnnotation(annotation, this.qualifiers);
    }

    public ClassConfig addInterceptorBinding(Class<? extends Annotation> annotation) {
        return this.addMetaAnnotation(annotation, this.interceptorBindings);
    }

    public ClassConfig addStereotype(Class<? extends Annotation> annotation) {
        return this.addMetaAnnotation(annotation, this.stereotypes);
    }

    private ClassConfig addMetaAnnotation(Class<? extends Annotation> annotation, Map<DotName, ClassConfig> map) {
        DotName annotationName = DotName.createSimple((String)annotation.getName());
        ClassInfo jandexClass = this.applicationIndex.getClassByName(annotationName);
        ClassConfigImpl classConfig = new ClassConfigImpl(this.applicationIndex, this.annotationOverlay, jandexClass);
        map.put(annotationName, classConfig);
        return classConfig;
    }

    public void addContext(Class<? extends Annotation> scopeAnnotation, Class<? extends AlterableContext> contextClass) {
        Objects.requireNonNull(scopeAnnotation);
        Objects.requireNonNull(contextClass);
        this.contexts.add(new ContextData(contextClass, scopeAnnotation, null));
    }

    public void addContext(Class<? extends Annotation> scopeAnnotation, boolean isNormal, Class<? extends AlterableContext> contextClass) {
        Objects.requireNonNull(scopeAnnotation);
        Objects.requireNonNull(contextClass);
        this.contexts.add(new ContextData(contextClass, scopeAnnotation, isNormal));
    }

    static final class ContextData {
        Class<? extends Annotation> scopeAnnotation;
        Boolean isNormal;
        Class<? extends AlterableContext> contextClass;

        ContextData(Class<? extends AlterableContext> contextClass, Class<? extends Annotation> scopeAnnotation, Boolean isNormal) {
            this.contextClass = contextClass;
            this.scopeAnnotation = scopeAnnotation;
            this.isNormal = isNormal;
        }
    }
}

