/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CertPathDeserializer
extends StdDeserializer<CertPath> {
    public CertPathDeserializer() {
        super(CertPath.class);
    }

    @NotNull
    public CertPath deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) throws IOException {
        ObjectCodec oc = p.getCodec();
        ArrayNode node = (ArrayNode)oc.readTree(p);
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        for (JsonNode item : node) {
            X509Certificate certificate = (X509Certificate)oc.treeToValue((TreeNode)item, X509Certificate.class);
            list.add(certificate);
        }
        return CertificateUtil.generateCertPath(list);
    }
}

