/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CharReplacementResultMapper;
import io.quarkus.qute.RawString;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.Variant;
import java.util.List;
import java.util.Optional;

public class HtmlEscaper
extends CharReplacementResultMapper {
    private final List<String> escapedContentTypes;
    private static final String[] REPLACEMENTS = new String[]{null, "&quot;", "&#39;", "&amp;", "&lt;", "&gt;", null, null};
    private static final byte[] LATIN_REPLACEMENT_ID_TABLE = HtmlEscaper.createLatinReplacementData();
    private static final int REPLACEMENT_ID_MASK = 7;

    private static byte[] createLatinReplacementData() {
        byte[] data = new byte[256];
        HtmlEscaper.setLatinReplacementId(data, 34, 1);
        HtmlEscaper.setLatinReplacementId(data, 39, 2);
        HtmlEscaper.setLatinReplacementId(data, 38, 3);
        HtmlEscaper.setLatinReplacementId(data, 60, 4);
        HtmlEscaper.setLatinReplacementId(data, 62, 5);
        assert (HtmlEscaper.getLatinReplacementId(data, 34) == 1);
        assert (HtmlEscaper.getLatinReplacementId(data, 39) == 2);
        assert (HtmlEscaper.getLatinReplacementId(data, 38) == 3);
        assert (HtmlEscaper.getLatinReplacementId(data, 60) == 4);
        assert (HtmlEscaper.getLatinReplacementId(data, 62) == 5);
        return data;
    }

    private static void setLatinReplacementId(byte[] data, int c, int id) {
        if (c > 255) {
            throw new IllegalArgumentException("Only Latin characters are supported: " + c);
        }
        if (id < 0 || id > 15) {
            throw new IllegalArgumentException("Replacement ID must be in range [0, 15] but was: " + id);
        }
        data[c] = (byte)id;
    }

    private static int getLatinReplacementId(byte[] data, int c) {
        return data[c] & 7;
    }

    private static String replacementOf(char c) {
        if (c > '\u00ff') {
            return null;
        }
        int replacementId = HtmlEscaper.getLatinReplacementId(LATIN_REPLACEMENT_ID_TABLE, c & 0xFF);
        if (replacementId == 0) {
            return null;
        }
        return REPLACEMENTS[replacementId];
    }

    public HtmlEscaper(List<String> escapedContentTypes) {
        this.escapedContentTypes = escapedContentTypes;
    }

    @Override
    public boolean appliesTo(TemplateNode.Origin origin, Object result) {
        if (result instanceof RawString) {
            return false;
        }
        Optional<Variant> variant = origin.getVariant();
        if (variant.isPresent()) {
            return this.requiresDefaultEscaping(variant.get());
        }
        return false;
    }

    private boolean requiresDefaultEscaping(Variant variant) {
        String contentType = variant.getContentType();
        if (contentType == null) {
            return false;
        }
        for (String escaped : this.escapedContentTypes) {
            if (!contentType.startsWith(escaped)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String replacementFor(char c) {
        return HtmlEscaper.replacementOf(c);
    }
}

