/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Objects;
import twitter4j.HttpResponse;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponseImpl;
import twitter4j.v1.OEmbed;

class OEmbedJSONImpl
extends TwitterResponseImpl
implements OEmbed,
Serializable {
    private static final long serialVersionUID = -2207801480251709819L;
    private String html;
    private String authorName;
    private String url;
    private String version;
    private long cacheAge;
    private String authorURL;
    private int width;

    OEmbedJSONImpl(HttpResponse res, boolean jsonStoreEnabled) throws TwitterException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (jsonStoreEnabled) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, json);
        }
    }

    OEmbedJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            this.html = json.getString("html");
            this.authorName = json.getString("author_name");
            this.url = json.getString("url");
            this.version = json.getString("version");
            this.cacheAge = json.getLong("cache_age");
            this.authorURL = json.getString("author_url");
            this.width = json.getInt("width");
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public String getHtml() {
        return this.html;
    }

    @Override
    public String getAuthorName() {
        return this.authorName;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public long getCacheAge() {
        return this.cacheAge;
    }

    @Override
    public String getAuthorURL() {
        return this.authorURL;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OEmbedJSONImpl that = (OEmbedJSONImpl)o;
        if (this.cacheAge != that.cacheAge) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (!Objects.equals(this.authorName, that.authorName)) {
            return false;
        }
        if (!Objects.equals(this.authorURL, that.authorURL)) {
            return false;
        }
        if (!Objects.equals(this.html, that.html)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        int result = this.html != null ? this.html.hashCode() : 0;
        result = 31 * result + (this.authorName != null ? this.authorName.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (int)(this.cacheAge ^ this.cacheAge >>> 32);
        result = 31 * result + (this.authorURL != null ? this.authorURL.hashCode() : 0);
        result = 31 * result + this.width;
        return result;
    }

    public String toString() {
        return "OEmbedJSONImpl{html='" + this.html + '\'' + ", authorName='" + this.authorName + '\'' + ", url='" + this.url + '\'' + ", version='" + this.version + '\'' + ", cacheAge=" + this.cacheAge + ", authorURL='" + this.authorURL + '\'' + ", width=" + this.width + '}';
    }
}

