/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.marshall.core.Ids;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class TransientMortalCacheEntry
extends AbstractInternalCacheEntry {
    protected long maxIdle;
    protected long lastUsed;
    protected long lifespan;
    protected long created;

    public TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan, long currentTimeMillis) {
        this(key, value, maxIdle, lifespan, currentTimeMillis, currentTimeMillis);
    }

    public TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan, long lastUsed, long created) {
        this(key, value, null, maxIdle, lifespan, lastUsed, created);
    }

    protected TransientMortalCacheEntry(Object key, Object value, PrivateMetadata internalMetadata, long maxIdle, long lifespan, long lastUsed, long created) {
        super(key, value, internalMetadata);
        this.maxIdle = maxIdle;
        this.lifespan = lifespan;
        this.created = created;
        this.lastUsed = lastUsed;
    }

    public void setLifespan(long lifespan) {
        this.lifespan = lifespan;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public long getLifespan() {
        return this.lifespan;
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean canExpireMaxIdle() {
        return true;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.maxIdle, this.lastUsed, this.lifespan, this.created, now);
    }

    @Override
    public final long getExpiryTime() {
        long muet;
        long lset = this.lifespan > -1L ? this.created + this.lifespan : -1L;
        long l = muet = this.maxIdle > -1L ? this.lastUsed + this.maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    public InternalCacheValue<?> toInternalCacheValue() {
        return new TransientMortalCacheValue(this.value, this.internalMetadata, this.created, this.lifespan, this.maxIdle, this.lastUsed);
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.lastUsed = currentTimeMillis;
    }

    @Override
    public void reincarnate(long now) {
        this.created = now;
    }

    @Override
    public long getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public Metadata getMetadata() {
        return new EmbeddedMetadata.Builder().lifespan(this.lifespan).maxIdle(this.maxIdle).build();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        throw new IllegalStateException("Metadata cannot be set on mortal entries. They need to be recreated via the entry factory.");
    }

    @Override
    public TransientMortalCacheEntry clone() {
        return (TransientMortalCacheEntry)super.clone();
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", lastUsed=").append(this.lastUsed);
        builder.append(", maxIdle=").append(this.maxIdle);
        builder.append(", created=").append(this.created);
        builder.append(", lifespan=").append(this.lifespan);
    }

    public static class Externalizer
    extends AbstractExternalizer<TransientMortalCacheEntry> {
        public void writeObject(ObjectOutput output, TransientMortalCacheEntry entry) throws IOException {
            output.writeObject(entry.key);
            output.writeObject(entry.value);
            output.writeObject(entry.internalMetadata);
            UnsignedNumeric.writeUnsignedLong((DataOutput)output, (long)entry.created);
            output.writeLong(entry.lifespan);
            UnsignedNumeric.writeUnsignedLong((DataOutput)output, (long)entry.lastUsed);
            output.writeLong(entry.maxIdle);
        }

        public TransientMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object key = input.readObject();
            Object value = input.readObject();
            PrivateMetadata internalMetadata = (PrivateMetadata)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong((DataInput)input);
            long lifespan = input.readLong();
            long lastUsed = UnsignedNumeric.readUnsignedLong((DataInput)input);
            long maxIdle = input.readLong();
            return new TransientMortalCacheEntry(key, value, internalMetadata, maxIdle, lifespan, lastUsed, created);
        }

        public Integer getId() {
            return Ids.TRANSIENT_MORTAL_ENTRY;
        }

        public Set<Class<? extends TransientMortalCacheEntry>> getTypeClasses() {
            return Collections.singleton(TransientMortalCacheEntry.class);
        }
    }
}

