/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.converters.uni.BuiltinConverters;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;

public class UniConvert<T> {
    private final Uni<T> upstream;

    public UniConvert(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public <R> R with(Function<Uni<T>, R> converter) {
        return ParameterValidation.nonNull(converter, "converter").apply(this.upstream);
    }

    @CheckReturnValue
    public CompletionStage<T> toCompletionStage() {
        return (CompletionStage)this.with(BuiltinConverters.toCompletionStage());
    }

    @CheckReturnValue
    public CompletableFuture<T> toCompletableFuture() {
        return (CompletableFuture)this.with(BuiltinConverters.toCompletableFuture());
    }

    @CheckReturnValue
    public Flow.Publisher<T> toPublisher() {
        return (Flow.Publisher)this.with(BuiltinConverters.toPublisher());
    }
}

