/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.function.Function;
import java.util.function.Supplier;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.cache.infinispan.LazyLoader;

public class DefaultLazyLoader<S, D>
implements LazyLoader<S, D> {
    private final Function<S, D> loader;
    private final Supplier<D> fallback;
    private volatile D data;

    public DefaultLazyLoader(Function<S, D> loader, Supplier<D> fallback) {
        this.loader = loader;
        this.fallback = fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public D get(KeycloakSession session, Supplier<S> sourceSupplier) {
        if (this.data == null) {
            DefaultLazyLoader defaultLazyLoader = this;
            synchronized (defaultLazyLoader) {
                if (this.data == null) {
                    AdminPermissionsSchema.runWithoutAuthorization((KeycloakSession)session, () -> {
                        Object source = sourceSupplier.get();
                        this.data = source == null ? this.fallback.get() : this.loader.apply(source);
                    });
                }
            }
        }
        return this.data;
    }
}

