/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.Comparator;
import org.keycloak.component.ComponentModel;
import org.keycloak.storage.ldap.LDAPConfig;

public class LDAPMappersComparator {
    private LDAPConfig ldapConfig;

    public LDAPMappersComparator(LDAPConfig ldapConfig) {
        this.ldapConfig = ldapConfig;
    }

    public Comparator<ComponentModel> sortAsc() {
        return new ImportantFirstComparator(this.ldapConfig);
    }

    public Comparator<ComponentModel> sortDesc() {
        return new ImportantFirstComparator(this.ldapConfig).reversed();
    }

    private static class ImportantFirstComparator
    implements Comparator<ComponentModel> {
        private final LDAPConfig ldapConfig;

        public ImportantFirstComparator(LDAPConfig ldapConfig) {
            this.ldapConfig = ldapConfig;
        }

        @Override
        public int compare(ComponentModel o1, ComponentModel o2) {
            boolean isO2LdapAttr;
            boolean isO2UsernameMapper;
            boolean isO1AttrMapper = o1.getProviderId().equals("user-attribute-ldap-mapper");
            boolean isO2AttrMapper = o2.getProviderId().equals("user-attribute-ldap-mapper");
            if (!isO1AttrMapper) {
                if (isO2AttrMapper) {
                    return 1;
                }
                return ImportantFirstComparator.compareWithStableOrdering(o1, o2);
            }
            if (!isO2AttrMapper) {
                return -1;
            }
            String model1 = (String)o1.getConfig().getFirst((Object)"user.model.attribute");
            String model2 = (String)o2.getConfig().getFirst((Object)"user.model.attribute");
            boolean isO1UsernameMapper = model1 != null && model1.equalsIgnoreCase("username");
            boolean bl = isO2UsernameMapper = model2 != null && model2.equalsIgnoreCase("username");
            if (!isO1UsernameMapper) {
                if (isO2UsernameMapper) {
                    return 1;
                }
                return ImportantFirstComparator.compareWithStableOrdering(o1, o2);
            }
            if (!isO2UsernameMapper) {
                return -1;
            }
            String o1LdapAttr = (String)o1.getConfig().getFirst((Object)"ldap.attribute");
            String o2LdapAttr = (String)o2.getConfig().getFirst((Object)"ldap.attribute");
            boolean isO1LdapAttr = o1LdapAttr != null && this.ldapConfig.getUsernameLdapAttribute().equalsIgnoreCase(o1LdapAttr);
            boolean bl2 = isO2LdapAttr = o2LdapAttr != null && this.ldapConfig.getUsernameLdapAttribute().equalsIgnoreCase(o2LdapAttr);
            if (!isO1LdapAttr) {
                if (isO2LdapAttr) {
                    return 1;
                }
                return ImportantFirstComparator.compareWithStableOrdering(o1, o2);
            }
            if (!isO2LdapAttr) {
                return -1;
            }
            return ImportantFirstComparator.compareWithStableOrdering(o1, o2);
        }

        private static int compareWithStableOrdering(ComponentModel o1, ComponentModel o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

