/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.comms;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.reflect.Method;
import java.util.Map;

public class ReflectionInfo {
    private final boolean blocking;
    private final boolean nonBlocking;
    public Class bean;
    public Object instance;
    public Method method;
    public Map<String, Class> params;

    public ReflectionInfo(Class bean, Object instance, Method method, Map<String, Class> params, boolean explicitlyBlocking, boolean explicitlyNonBlocking) {
        this.bean = bean;
        this.instance = instance;
        this.method = method;
        this.params = params;
        this.blocking = explicitlyBlocking;
        this.nonBlocking = explicitlyNonBlocking;
        if (this.blocking && this.nonBlocking) {
            throw new IllegalArgumentException("The method " + method.getDeclaringClass().getName() + "." + method.getName() + " cannot be annotated with @Blocking and @NonBlocking");
        }
    }

    public boolean isReturningMulti() {
        Class<?> returnType = this.method.getReturnType();
        return returnType.getName().equals(Multi.class.getName());
    }

    public boolean isExplicitlyBlocking() {
        return this.blocking;
    }

    public boolean isExplicitlyNonBlocking() {
        return this.nonBlocking;
    }

    public boolean isReturningUni() {
        return this.method.getReturnType().getName().equals(Uni.class.getName());
    }
}

