/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class ReturnFields
implements Iterable<String> {
    public static ReturnFields ALL = new ReturnFields(){

        @Override
        public ReturnFields child(String field) {
            return NONE;
        }

        @Override
        public boolean included(String ... pathSegments) {
            return true;
        }

        @Override
        public boolean excluded(String field) {
            return false;
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.singletonList("*").iterator();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isAll() {
            return true;
        }

        @Override
        public String toString() {
            return "[ReturnFields ALL]";
        }
    };
    public static ReturnFields NONE = new ReturnFields(){

        @Override
        public ReturnFields child(String field) {
            return this;
        }

        @Override
        public boolean included(String ... pathSegments) {
            return false;
        }

        @Override
        public boolean excluded(String field) {
            return false;
        }

        @Override
        public Iterator<String> iterator() {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isAll() {
            return false;
        }

        @Override
        public String toString() {
            return "[ReturnFields NONE]";
        }
    };
    public static ReturnFields ALL_RECURSIVELY = new ReturnFields(){

        @Override
        public ReturnFields child(String field) {
            return this;
        }

        @Override
        public boolean included(String ... pathSegments) {
            return true;
        }

        @Override
        public boolean excluded(String field) {
            return false;
        }

        @Override
        public Iterator<String> iterator() {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isAll() {
            return true;
        }
    };
    private HashMap<String, ReturnFields> fields = new LinkedHashMap<String, ReturnFields>();

    public ReturnFields() {
    }

    public ReturnFields(String spec) {
        int i;
        if (spec == null || spec.trim().length() == 0) {
            throw new IllegalArgumentException("Fields spec is null or empty!");
        }
        char[] buf = spec.toCharArray();
        StringBuilder token = new StringBuilder(buf.length);
        LinkedList<HashMap<String, ReturnFields>> specs = new LinkedList<HashMap<String, ReturnFields>>();
        specs.add(this.fields);
        FieldState fldState = FieldState.start;
        TargetState state = TargetState.Ident;
        for (i = 0; i < buf.length; ++i) {
            char c = buf[i];
            if (c == ',') {
                if (state == TargetState.Ident) {
                    this.error(spec, i);
                }
                if (fldState == FieldState.name) {
                    ((HashMap)specs.getLast()).put(token.toString(), null);
                    token.setLength(0);
                }
                state = TargetState.Ident;
                fldState = FieldState.start;
                continue;
            }
            if (c == '(') {
                if (state != TargetState.IdentCommaOpen && state != TargetState.Anything) {
                    this.error(spec, i);
                }
                ReturnFields sub = new ReturnFields();
                ((HashMap)specs.getLast()).put(token.toString(), sub);
                specs.add(sub.fields);
                token.setLength(0);
                state = TargetState.Ident;
                fldState = FieldState.start;
                continue;
            }
            if (c == ')') {
                if (state != TargetState.Anything) {
                    this.error(spec, i);
                }
                if (fldState == FieldState.name) {
                    ((HashMap)specs.getLast()).put(token.toString(), null);
                    token.setLength(0);
                }
                specs.removeLast();
                fldState = FieldState.end;
                state = specs.size() > 1 ? TargetState.Anything : TargetState.Comma;
                continue;
            }
            token.append(c);
            if (fldState != FieldState.start) continue;
            fldState = FieldState.name;
            state = specs.size() > 1 ? TargetState.Anything : TargetState.IdentCommaOpen;
        }
        if (specs.size() > 1) {
            this.error(spec, i);
        }
        if (token.length() > 0) {
            ((HashMap)specs.getLast()).put(token.toString(), null);
        } else if (state != TargetState.Anything && state != TargetState.Comma) {
            this.error(spec, i);
        }
    }

    private void error(String spec, int i) {
        throw new RuntimeException("Invalid fields specification at position " + i + ": " + spec);
    }

    public ReturnFields child(String field) {
        ReturnFields returnFields = this.fields.get(field);
        if (returnFields == null && (returnFields = this.fields.get("*")) == null) {
            returnFields = NONE;
        }
        return returnFields;
    }

    public boolean included(String ... pathSegments) {
        if (pathSegments == null || pathSegments.length == 0) {
            throw new IllegalArgumentException("No path specified!");
        }
        ReturnFields current = this;
        for (String path : pathSegments) {
            if (current == null) {
                return false;
            }
            if (current.fields.containsKey("-" + path)) {
                return false;
            }
            if (current.fields.containsKey("*")) {
                return true;
            }
            if (!current.fields.containsKey(path)) {
                return false;
            }
            current = current.fields.get(path);
        }
        return true;
    }

    public boolean excluded(String field) {
        return this.fields.containsKey("-" + field);
    }

    @Override
    public Iterator<String> iterator() {
        return this.fields.keySet().iterator();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public boolean isAll() {
        return this.fields.keySet().contains("*");
    }

    public String toString() {
        return "[ReturnFieldsImpl: fields=" + String.valueOf(this.fields) + "]";
    }

    private static enum FieldState {
        start,
        name,
        end;

    }

    private static enum TargetState {
        IdentCommaOpen,
        Ident,
        Comma,
        Anything;

    }
}

