/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.UniqueKey;

public class SkipNullableUniqueDelegate
extends CreateTableUniqueDelegate {
    public SkipNullableUniqueDelegate(Dialect dialect) {
        super(dialect);
    }

    @Override
    public String getColumnDefinitionUniquenessFragment(Column column, SqlStringGenerationContext context) {
        return column.isNullable() ? "" : super.getColumnDefinitionUniquenessFragment(column, context);
    }

    @Override
    protected void appendUniqueConstraint(StringBuilder fragment, UniqueKey uniqueKey) {
        if (!uniqueKey.hasNullableColumn()) {
            super.appendUniqueConstraint(fragment, uniqueKey);
        }
    }

    @Override
    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
        return uniqueKey.hasNullableColumn() ? "" : super.getAlterTableToAddUniqueKeyCommand(uniqueKey, metadata, context);
    }

    @Override
    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
        return uniqueKey.hasNullableColumn() ? "" : super.getAlterTableToDropUniqueKeyCommand(uniqueKey, metadata, context);
    }
}

