/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.NamedAuxiliaryDatabaseObject;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleEnumJdbcType;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.internal.EnumHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleOrdinalEnumJdbcType
extends OracleEnumJdbcType {
    public static final OracleOrdinalEnumJdbcType INSTANCE = new OracleOrdinalEnumJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 4;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 6003;
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, OracleOrdinalEnumJdbcType.this.getJdbcTypeCode());
            }

            @Override
            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, OracleOrdinalEnumJdbcType.this.getJdbcTypeCode());
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setInt(index, ((Enum)value).ordinal() + 1);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setInt(name, ((Enum)value).ordinal() + 1);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                int value = rs.getInt(paramIndex);
                if (rs.wasNull()) {
                    return this.getJavaType().wrap(null, options);
                }
                return this.getJavaType().wrap(value - 1, options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getInt(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getInt(name), options);
            }
        };
    }

    @Override
    public void addAuxiliaryDatabaseObjects(JavaType<?> javaType, Size columnSize, Database database, JdbcTypeIndicators context) {
        this.addAuxiliaryDatabaseObjects(javaType, database, false);
    }

    @Override
    public void addAuxiliaryDatabaseObjects(JavaType<?> javaType, Size columnSize, Database database, TypeConfiguration typeConfiguration) {
        this.addAuxiliaryDatabaseObjects(javaType, database, false);
    }

    private void addAuxiliaryDatabaseObjects(JavaType<?> javaType, Database database, boolean sortEnumValues) {
        Dialect dialect = database.getDialect();
        Class enumClass = (Class)javaType.getJavaType();
        String enumTypeName = enumClass.getSimpleName();
        Object[] enumeratedValues = EnumHelper.getEnumeratedValues(enumClass);
        if (sortEnumValues) {
            Arrays.sort(enumeratedValues);
        }
        String[] create = dialect.getCreateEnumTypeCommand(javaType.getJavaTypeClass().getSimpleName(), (String[])enumeratedValues);
        String[] drop = dialect.getDropEnumTypeCommand(enumClass);
        if (create != null && create.length > 0) {
            database.addAuxiliaryDatabaseObject(new NamedAuxiliaryDatabaseObject(enumTypeName, database.getDefaultNamespace(), create, drop, Collections.emptySet(), true));
        }
    }
}

