/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.hibernate.Internal;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.bytecode.internal.none.BytecodeProviderImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class BytecodeProviderInitiator
implements StandardServiceInitiator<BytecodeProvider> {
    @Deprecated(forRemoval=true)
    public static final String BYTECODE_PROVIDER_NAME_BYTEBUDDY = "bytebuddy";
    @Deprecated(forRemoval=true)
    public static final String BYTECODE_PROVIDER_NAME_NONE = "none";
    @Deprecated(forRemoval=true)
    public static final String BYTECODE_PROVIDER_NAME_DEFAULT = "bytebuddy";
    public static final StandardServiceInitiator<BytecodeProvider> INSTANCE = new BytecodeProviderInitiator();

    @Override
    public BytecodeProvider initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        Collection<BytecodeProvider> bytecodeProviders = registry.requireService(ClassLoaderService.class).loadJavaServices(BytecodeProvider.class);
        return BytecodeProviderInitiator.getBytecodeProvider(bytecodeProviders);
    }

    @Override
    public Class<BytecodeProvider> getServiceInitiated() {
        return BytecodeProvider.class;
    }

    @Internal
    public static BytecodeProvider buildDefaultBytecodeProvider() {
        return BytecodeProviderInitiator.getBytecodeProvider(ServiceLoader.load(BytecodeProvider.class, BytecodeProvider.class.getClassLoader()));
    }

    @Internal
    public static BytecodeProvider getBytecodeProvider(Iterable<BytecodeProvider> bytecodeProviders) {
        Iterator<BytecodeProvider> iterator = bytecodeProviders.iterator();
        if (!iterator.hasNext()) {
            return new BytecodeProviderImpl();
        }
        BytecodeProvider provider = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException("Found multiple BytecodeProvider service registrations, cannot determine which one to use");
        }
        return provider;
    }
}

