/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCommitInsertEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.stat.spi.StatisticsImplementor;

public class EntityIdentityInsertAction
extends AbstractEntityInsertAction {
    private final boolean isDelayed;
    private final EntityKey delayedEntityKey;
    private EntityKey entityKey;
    private Object generatedId;
    private Object rowId;

    public EntityIdentityInsertAction(Object[] state, Object instance, EntityPersister persister, boolean isVersionIncrementDisabled, EventSource session, boolean isDelayed) {
        super(isDelayed ? EntityIdentityInsertAction.generateDelayedPostInsertIdentifier() : null, state, instance, isVersionIncrementDisabled, persister, session);
        this.isDelayed = isDelayed;
        this.delayedEntityKey = isDelayed ? this.generateDelayedEntityKey() : null;
    }

    @Override
    public void execute() throws HibernateException {
        this.nullifyTransientReferencesIfNotAlready();
        EntityPersister persister = this.getPersister();
        EventSource session = this.getSession();
        Object instance = this.getInstance();
        this.setVeto(this.preInsert());
        if (!this.isVeto()) {
            GeneratedValues generatedValues = persister.getInsertCoordinator().insert(instance, this.getState(), session);
            this.generatedId = NullnessUtil.castNonNull(generatedValues).getGeneratedValue(persister.getIdentifierMapping());
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            if (persister.getRowIdMapping() != null) {
                this.rowId = generatedValues.getGeneratedValue(persister.getRowIdMapping());
                if (this.rowId != null && this.isDelayed) {
                    persistenceContext.replaceEntityEntryRowId(this.getInstance(), this.rowId);
                }
            }
            if (persister.hasInsertGeneratedProperties()) {
                persister.processInsertGeneratedProperties(this.generatedId, instance, this.getState(), generatedValues, session);
            }
            persister.setIdentifier(instance, this.generatedId, session);
            persistenceContext.registerInsertedKey(this.getPersister(), this.generatedId);
            this.entityKey = session.generateEntityKey(this.generatedId, persister);
            persistenceContext.checkUniqueness(this.entityKey, this.getInstance());
        }
        this.postInsert();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled() && !this.isVeto()) {
            statistics.insertEntity(this.getPersister().getEntityName());
        }
        this.markExecuted();
    }

    @Override
    public boolean needsAfterTransactionCompletion() {
        return this.hasPostCommitEventListeners();
    }

    @Override
    protected boolean hasPostCommitEventListeners() {
        EventListenerGroup<PostInsertEventListener> group = this.getFastSessionServices().eventListenerGroup_POST_COMMIT_INSERT;
        for (PostInsertEventListener listener : group.listeners()) {
            if (!listener.requiresPostCommitHandling(this.getPersister())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) {
        this.postCommitInsert(success);
    }

    protected void postInsert() {
        if (this.isDelayed) {
            this.eventSource().getPersistenceContextInternal().replaceDelayedEntityIdentityInsertKeys(this.delayedEntityKey, this.generatedId);
        }
        this.getFastSessionServices().eventListenerGroup_POST_INSERT.fireLazyEventOnEachListener(this::newPostInsertEvent, PostInsertEventListener::onPostInsert);
    }

    PostInsertEvent newPostInsertEvent() {
        return new PostInsertEvent(this.getInstance(), this.generatedId, this.getState(), this.getPersister(), this.eventSource());
    }

    protected void postCommitInsert(boolean success) {
        this.getFastSessionServices().eventListenerGroup_POST_COMMIT_INSERT.fireLazyEventOnEachListener(this::newPostInsertEvent, success ? PostInsertEventListener::onPostInsert : this::postCommitInsertOnFailure);
    }

    private void postCommitInsertOnFailure(PostInsertEventListener listener, PostInsertEvent event) {
        if (listener instanceof PostCommitInsertEventListener) {
            ((PostCommitInsertEventListener)listener).onPostInsertCommitFailed(event);
        } else {
            listener.onPostInsert(event);
        }
    }

    protected boolean preInsert() {
        EventListenerGroup<PreInsertEventListener> listenerGroup = this.getFastSessionServices().eventListenerGroup_PRE_INSERT;
        if (listenerGroup.isEmpty()) {
            return false;
        }
        PreInsertEvent event = new PreInsertEvent(this.getInstance(), null, this.getState(), this.getPersister(), this.eventSource());
        boolean veto = false;
        for (PreInsertEventListener listener : listenerGroup.listeners()) {
            veto |= listener.onPreInsert(event);
        }
        return veto;
    }

    public final Object getGeneratedId() {
        return this.generatedId;
    }

    protected void setGeneratedId(Object generatedId) {
        this.generatedId = generatedId;
    }

    @Override
    public boolean isEarlyInsert() {
        return !this.isDelayed;
    }

    @Override
    protected EntityKey getEntityKey() {
        return this.entityKey != null ? this.entityKey : this.delayedEntityKey;
    }

    @Override
    public Object getRowId() {
        return this.rowId;
    }

    protected void setEntityKey(EntityKey entityKey) {
        this.entityKey = entityKey;
    }

    private static DelayedPostInsertIdentifier generateDelayedPostInsertIdentifier() {
        return new DelayedPostInsertIdentifier();
    }

    protected EntityKey generateDelayedEntityKey() {
        if (this.isDelayed) {
            return this.getSession().generateEntityKey(this.getDelayedId(), this.getPersister());
        }
        throw new AssertionFailure("cannot request delayed entity-key for early-insert post-insert-id generation");
    }
}

