/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.indy.Bootstrap;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class YieldSite
extends MutableCallSite {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final boolean unwrap;
    private int bindCount;
    private static final int MAX_REBIND = 2;
    private static final Logger LOG = LoggerFactory.getLogger(YieldSite.class);
    public static final Handle BOOTSTRAP = new Handle(6, CodegenUtils.p(YieldSite.class), "bootstrap", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE), false);

    public YieldSite(MethodType type2, boolean unwrap) {
        super(type2);
        this.unwrap = unwrap;
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, int unwrap) throws Throwable {
        YieldSite site = new YieldSite(type2, unwrap == 1);
        site.setTarget(switch (name2) {
            case "yield", "yieldSpecific" -> Binder.from(type2).prepend(YieldSite.class, (Object)site).invokeVirtual(lookup, name2);
            case "yieldValues" -> Binder.from(type2).collect(2, IRubyObject[].class).prepend(YieldSite.class, (Object)site).invokeVirtual(lookup, name2);
            default -> throw new RuntimeException("invalid yield type: " + name2);
        });
        return site;
    }

    public IRubyObject yield(ThreadContext context, Block block, IRubyObject arg2) throws Throwable {
        if (Options.INVOKEDYNAMIC_YIELD.load().booleanValue()) {
            if (this.bindCount >= 2) {
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info("yield \tdisabled due to polymorphism:" + Bootstrap.logBlock(block), new Object[0]);
                }
            } else {
                MethodHandle target2;
                ++this.bindCount;
                BlockBody body = block.getBody();
                if (block.getBody() instanceof CompiledIRBlockBody) {
                    CompiledIRBlockBody compiledBody = (CompiledIRBlockBody)block.getBody();
                    if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                        LOG.info("yield \tbound directly as yield:" + Bootstrap.logBlock(block), new Object[0]);
                    }
                    target2 = this.unwrap ? compiledBody.getNormalYieldUnwrapHandle() : compiledBody.getNormalYieldHandle();
                } else {
                    if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                        LOG.info("yield \tbound indirectly as yield:" + Bootstrap.logBlock(block), new Object[0]);
                    }
                    target2 = Binder.from(this.type()).append(this.unwrap).invokeStaticQuiet(LOOKUP, IRRuntimeHelpers.class, "yield");
                }
                MethodHandle fallback = this.getTarget();
                MethodHandle test2 = body.getTestBlockBody();
                MethodHandle guard = MethodHandles.guardWithTest(test2, target2, fallback);
                this.setTarget(guard);
                return target2.invokeExact(context, block, arg2);
            }
        }
        return IRRuntimeHelpers.yield(context, block, arg2, this.unwrap);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Block block) throws Throwable {
        if (Options.INVOKEDYNAMIC_YIELD.load().booleanValue()) {
            if (this.bindCount >= 2) {
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info("yield \tdisabled due to polymorphism:" + Bootstrap.logBlock(block), new Object[0]);
                }
            } else {
                MethodHandle target2;
                ++this.bindCount;
                BlockBody body = block.getBody();
                if (block.getBody() instanceof CompiledIRBlockBody) {
                    CompiledIRBlockBody compiledBody = (CompiledIRBlockBody)block.getBody();
                    if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                        LOG.info("yield \tbound directly as yieldSpecific:" + Bootstrap.logBlock(block), new Object[0]);
                    }
                    target2 = compiledBody.getNormalYieldSpecificHandle();
                } else {
                    if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                        LOG.info("yield \tbound indirectly as yieldSpecific:" + Bootstrap.logBlock(block), new Object[0]);
                    }
                    target2 = Binder.from(this.type()).permute(1, 0).invokeVirtualQuiet(LOOKUP, "yieldSpecific");
                }
                MethodHandle fallback = this.getTarget();
                MethodHandle test2 = body.getTestBlockBody();
                MethodHandle guard = MethodHandles.guardWithTest(test2, target2, fallback);
                this.setTarget(guard);
                return target2.invokeExact(context, block);
            }
        }
        return block.yieldSpecific(context);
    }

    public IRubyObject yieldValues(ThreadContext context, Block block, IRubyObject[] args2) {
        if (Options.INVOKEDYNAMIC_YIELD.load().booleanValue() && Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.info("yield \tbound indirectly as yieldValues:" + Bootstrap.logBlock(block), new Object[0]);
        }
        MethodHandle target2 = Binder.from(this.type()).collect(2, IRubyObject[].class).permute(1, 0, 2).invokeVirtualQuiet(LOOKUP, "yieldValues");
        this.setTarget(target2);
        return block.yieldValues(context, args2);
    }
}

