/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.targets.simple.ConstantLookupSite;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SearchConstInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    private final RubySymbol constantName;
    private final boolean noPrivateConsts;
    private final ConstantLookupSite site;

    public SearchConstInstr(Variable result2, Operand startingScope, RubySymbol constantName, boolean noPrivateConsts) {
        super(Operation.SEARCH_CONST, result2, startingScope);
        assert (result2 != null) : "SearchConstInstr result is null";
        this.constantName = constantName;
        this.noPrivateConsts = noPrivateConsts;
        this.site = new ConstantLookupSite(constantName);
    }

    public Operand getStartingScope() {
        return this.getOperand1();
    }

    public String getId() {
        return this.constantName.idString();
    }

    public RubySymbol getName() {
        return this.constantName;
    }

    public boolean isNoPrivateConsts() {
        return this.noPrivateConsts;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new SearchConstInstr(ii.getRenamedVariable(this.result), this.getStartingScope().cloneForInlining(ii), this.constantName, this.noPrivateConsts);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getName());
        e.encode(this.isNoPrivateConsts());
    }

    public static SearchConstInstr decode(IRReaderDecoder d) {
        return new SearchConstInstr(d.decodeVariable(), d.decodeOperand(), d.decodeSymbol(), d.decodeBoolean());
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + String.valueOf(this.getName()), "no_priv: " + this.noPrivateConsts};
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        StaticScope staticScope = (StaticScope)this.getStartingScope().retrieve(context, self2, currScope, currDynScope, temp);
        return this.site.searchConst(context, staticScope, this.noPrivateConsts);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SearchConstInstr(this);
    }
}

